/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.spring;

import com.hb0730.commons.lang.convert.ConverterRegistry;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    public static String getParameter(String name) {
        return ServletUtils.getRequest().getParameter(name);
    }

    public static String getParameter(String name, String defaultValue) {
        return (String)ConverterRegistry.getInstance().convert(String.class, (Object)ServletUtils.getRequest().getParameter(name), (Object)defaultValue);
    }

    public static Integer getParameterToInt(String name) {
        return (Integer)ConverterRegistry.getInstance().convert(Integer.class, (Object)ServletUtils.getRequest().getParameter(name));
    }

    public static Integer getParameterToInt(String name, Integer defaultValue) {
        return (Integer)ConverterRegistry.getInstance().convert(Integer.class, (Object)ServletUtils.getRequest().getParameter(name), (Object)defaultValue);
    }

    public static HttpSession getSession() {
        return ServletUtils.getRequest().getSession();
    }

    public static HttpServletRequest getRequest() {
        return ServletUtils.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtils.getRequestAttributes().getResponse();
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static void renderString(HttpServletResponse response, String string) throws IOException {
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        response.getWriter().print(string);
    }
}

