/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.spring;

import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class SpringContextUtils {
    private static ApplicationContext applicationContext;

    public static ApplicationContext getApplicationContext() {
        Assert.notNull((Object)applicationContext, (String)"Please set it first ApplicationContext");
        return applicationContext;
    }

    public static void setApplicationContext(@NonNull ApplicationContext applicationContext) {
        SpringContextUtils.applicationContext = applicationContext;
    }

    public static <T> T getBean(String name) throws BeansException {
        return (T)SpringContextUtils.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clz) throws BeansException {
        return (T)SpringContextUtils.getApplicationContext().getBean(clz);
    }

    public static boolean containsBean(String name) {
        return SpringContextUtils.getApplicationContext().containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return SpringContextUtils.getApplicationContext().isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return SpringContextUtils.getApplicationContext().getType(name);
    }

    public static String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return SpringContextUtils.getApplicationContext().getAliases(name);
    }

    public static <T> T getAopProxy() {
        return (T)AopContext.currentProxy();
    }
}

