/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.spring;

import com.hb0730.commons.lang.collection.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.validation.FieldError;

public class ValidatorUtils {
    private static volatile Validator VALIDATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Validator getValidator() {
        if (VALIDATOR != null) return VALIDATOR;
        Class<ValidatorUtils> clazz = ValidatorUtils.class;
        synchronized (ValidatorUtils.class) {
            if (VALIDATOR != null) return VALIDATOR;
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return VALIDATOR;
        }
    }

    public static void validate(Object obj, Class<?> ... group) {
        Validator validator = ValidatorUtils.getValidator();
        Set constraintViolations = validator.validate(obj, (Class[])group);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)constraintViolations)) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }

    public static void validateList(@Nullable Iterable<?> objs, Class<?> ... groups) {
        if (objs == null) {
            return;
        }
        Validator validator = ValidatorUtils.getValidator();
        AtomicInteger i = new AtomicInteger(0);
        LinkedHashSet allViolations = new LinkedHashSet();
        objs.forEach(obj -> {
            int index = i.getAndIncrement();
            Set violations = validator.validate(obj, groups);
            violations.forEach(violation -> {
                Path path = violation.getPropertyPath();
                if (path instanceof PathImpl) {
                    PathImpl pathImpl = (PathImpl)path;
                    pathImpl.makeLeafNodeIterableAndSetIndex(Integer.valueOf(index));
                }
                allViolations.add(violation);
            });
        });
        if (!org.springframework.util.CollectionUtils.isEmpty(allViolations)) {
            throw new ConstraintViolationException(allViolations);
        }
    }

    @NonNull
    public static Map<String, String> mapWithValidError(Set<ConstraintViolation<?>> constraintViolations) {
        if (org.springframework.util.CollectionUtils.isEmpty(constraintViolations)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        constraintViolations.forEach(constraintViolation -> errMap.put(constraintViolation.getPropertyPath().toString(), constraintViolation.getMessage()));
        return errMap;
    }

    public static Map<String, String> mapWithFieldError(@Nullable List<FieldError> fieldErrors) {
        if (CollectionUtils.isEmpty(fieldErrors)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> errMap = new HashMap<String, String>(4);
        fieldErrors.forEach(filedError -> errMap.put(filedError.getField(), filedError.getDefaultMessage()));
        return errMap;
    }
}

