/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.commons.spring;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class BeanUtils {
    @Nullable
    public static <T> T transformFrom(@Nullable Object source, @NonNull Class<T> targetClass) {
        Assert.notNull(targetClass, (String)"Target class must not be null");
        if (source == null) {
            return null;
        }
        try {
            T targetInstance = targetClass.newInstance();
            org.springframework.beans.BeanUtils.copyProperties((Object)source, targetInstance, (String[])BeanUtils.getNullPropertyNames(source));
            return targetInstance;
        }
        catch (Exception e) {
            throw new BeanInstantiationException(targetClass, "Failed to new " + targetClass.getName() + " instance or copy properties", (Throwable)e);
        }
    }

    @NonNull
    public static <T> List<T> transformFromInBatch(Collection<?> sources, @NonNull Class<T> targetClass) {
        if (CollectionUtils.isEmpty(sources)) {
            return Collections.emptyList();
        }
        return sources.stream().map(source -> BeanUtils.transformFrom(source, targetClass)).collect(Collectors.toList());
    }

    public static void updateProperties(@NonNull Object source, @NonNull Object target) {
        Assert.notNull((Object)source, (String)"source object must not be null");
        Assert.notNull((Object)target, (String)"target object must not be null");
        org.springframework.beans.BeanUtils.copyProperties((Object)source, (Object)target, (String[])BeanUtils.getNullPropertyNames(source));
    }

    @NonNull
    private static String[] getNullPropertyNames(@NonNull Object source) {
        return BeanUtils.getNullPropertyNameSet(source).toArray(new String[0]);
    }

    @NonNull
    private static Set<String> getNullPropertyNameSet(@NonNull Object source) {
        Assert.notNull((Object)source, (String)"source object must not be null");
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(source);
        PropertyDescriptor[] propertyDescriptors = beanWrapper.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String propertyName = propertyDescriptor.getName();
            Object propertyValue = beanWrapper.getPropertyValue(propertyName);
            if (propertyValue != null) continue;
            emptyNames.add(propertyName);
        }
        return emptyNames;
    }

    public static <T> T map2bean(Map<String, Object> map, Class<T> clz) throws Exception {
        PropertyDescriptor[] pds;
        T obj = clz.newInstance();
        BeanInfo b = Introspector.getBeanInfo(clz, Object.class);
        for (PropertyDescriptor pd : pds = b.getPropertyDescriptors()) {
            Method setter = pd.getWriteMethod();
            setter.invoke(obj, map.get(pd.getName()));
        }
        return obj;
    }

    @NonNull
    public static <ID, D> Map<ID, D> convertToMap(Collection<D> list, @NonNull Function<D, ID> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"mapping function must not be null");
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap maps = new HashMap(16);
        list.forEach(data -> maps.putIfAbsent(mappingFunction.apply(data), data));
        return maps;
    }

    @NonNull
    public static <ID, D, V> Map<ID, V> convertToMap(@Nullable Collection<D> list, @NonNull Function<D, ID> keyFunction, @NonNull Function<D, V> valueFunction) {
        Assert.notNull(keyFunction, (String)"Key function must not be null");
        Assert.notNull(valueFunction, (String)"Value function must not be null");
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = new HashMap(16);
        list.forEach(data -> resultMap.putIfAbsent(keyFunction.apply(data), valueFunction.apply(data)));
        return resultMap;
    }
}

