/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.jsons;

import com.hb0730.jsons.SimpleJson;
import com.hb0730.jsons.SimpleJsonException;
import com.hb0730.jsons.support.gson.GsonImpl;
import com.hb0730.jsons.support.jackson.JacksonImpl;
import com.hb0730.jsons.util.ClassUtil;
import com.hb0730.jsons.util.Impls;

public class SimpleJsonProxy
implements SimpleJson {
    public static SimpleJsonProxy json = new SimpleJsonProxy();
    private static SimpleJson proxy;

    private void selectJsonProxy() {
        SimpleJson defaultJson = null;
        ClassLoader classLoader = SimpleJsonProxy.class.getClassLoader();
        if (ClassUtil.isPresent(Impls.JACKSON.getValue(), classLoader)) {
            defaultJson = this.getProxy(JacksonImpl.class);
        } else if (ClassUtil.isPresent(Impls.GSON.getValue(), classLoader)) {
            defaultJson = this.getProxy(GsonImpl.class);
        }
        if (defaultJson == null) {
            throw new SimpleJsonException("Has no JsonImpl defined in environment!");
        }
        proxy = defaultJson;
    }

    private <T extends SimpleJson> T getProxy(Class<T> clazz) {
        try {
            return (T)((SimpleJson)clazz.newInstance());
        }
        catch (Exception e) {
            return null;
        }
    }

    private synchronized void checkProxyNotNull(SimpleJson proxy) {
        if (null == proxy) {
            this.selectJsonProxy();
        }
    }

    public SimpleJsonProxy setJson(SimpleJson json) {
        proxy = json;
        return this;
    }

    @Override
    public <C> C getClient() {
        this.checkProxyNotNull(proxy);
        return proxy.getClient();
    }

    @Override
    public <C> void setClient(C client) {
        this.checkProxyNotNull(proxy);
        proxy.setClient(client);
    }

    @Override
    public String toJson(Object obj) {
        this.checkProxyNotNull(proxy);
        return proxy.toJson(obj);
    }

    @Override
    public <C> String toJson(Object obj, C client) {
        this.checkProxyNotNull(proxy);
        return proxy.toJson(obj, client);
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        this.checkProxyNotNull(proxy);
        return proxy.fromJson(json, clazz);
    }

    @Override
    public <T, C> T fromJson(String json, Class<T> clazz, C client) {
        this.checkProxyNotNull(proxy);
        return proxy.fromJson(json, clazz, client);
    }

    @Override
    public <T, Type> T fromJson(String json, Type type) {
        this.checkProxyNotNull(proxy);
        return proxy.fromJson(json, type);
    }

    @Override
    public <T, Type, C> T fromJson(String json, Type type, C client) {
        this.checkProxyNotNull(proxy);
        return proxy.fromJson(json, type, client);
    }
}

