/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.jsons.support.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hb0730.jsons.SimpleJson;
import com.hb0730.jsons.SimpleJsonException;
import java.lang.reflect.Type;

public class GsonImpl
implements SimpleJson {
    private Gson gson;

    public GsonImpl() {
        this(new GsonBuilder().create());
    }

    public GsonImpl(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <C> C getClient() {
        return (C)this.gson;
    }

    @Override
    public <C> void setClient(C client) {
        this.supportType(client);
        this.gson = (Gson)client;
    }

    @Override
    public String toJson(Object obj) {
        return this.toJson(obj, null);
    }

    @Override
    public <C> String toJson(Object obj, C client) {
        if (null == client) {
            return this.gson.toJson(obj);
        }
        this.supportType(client);
        return ((Gson)client).toJson(obj);
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        return this.fromJson(json, (Object)clazz, null);
    }

    @Override
    public <T, C> T fromJson(String json, Class<T> clazz, C client) {
        if (null == client) {
            return (T)this.gson.fromJson(json, clazz);
        }
        this.supportType(client);
        return (T)((Gson)client).fromJson(json, clazz);
    }

    @Override
    public <T, Type> T fromJson(String json, Type type) {
        return this.fromJson(json, type, null);
    }

    @Override
    public <T, Type, C> T fromJson(String json, Type type, C client) {
        this.supportJavaType(type);
        if (null == client) {
            return (T)this.gson.fromJson(json, (Type)type);
        }
        return (T)((Gson)client).fromJson(json, (Type)type);
    }

    protected <C> void supportType(C client) {
        if (!(client instanceof Gson)) {
            throw new SimpleJsonException("type mismatch");
        }
    }

    protected <Type> void supportJavaType(Type type) {
        if (!(type instanceof Type)) {
            throw new SimpleJsonException("type mismatch");
        }
    }
}

