/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.jsons.support.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hb0730.jsons.SimpleJson;
import com.hb0730.jsons.SimpleJsonException;

public class JacksonImpl
implements SimpleJson {
    private ObjectMapper mapper;

    public JacksonImpl() {
        this(new ObjectMapper());
    }

    public JacksonImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <C> C getClient() {
        return (C)this.mapper;
    }

    @Override
    public <C> void setClient(C client) {
        this.supportType(client);
        this.mapper = (ObjectMapper)client;
    }

    @Override
    public String toJson(Object obj) {
        return this.toJson(obj, null);
    }

    @Override
    public <C> String toJson(Object obj, C client) {
        try {
            if (null == client) {
                return this.mapper.writeValueAsString(obj);
            }
            this.supportType(client);
            return ((ObjectMapper)client).writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    public <T> T fromJson(String json, Class<T> clazz) {
        return this.fromJson(json, (Object)clazz, null);
    }

    @Override
    public <T, C> T fromJson(String json, Class<T> clazz, C client) {
        try {
            if (null == client) {
                return (T)this.mapper.readValue(json, clazz);
            }
            this.supportType(client);
            return (T)((ObjectMapper)client).readValue(json, clazz);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    public <T, Type> T fromJson(String json, Type type) {
        return this.fromJson(json, type, null);
    }

    @Override
    public <T, Type, C> T fromJson(String json, Type type, C client) {
        this.supportJavaType(type);
        boolean javaType = type instanceof JavaType;
        try {
            if (null == client && javaType) {
                return (T)this.mapper.readValue(json, (JavaType)type);
            }
            if (null == client) {
                return (T)this.mapper.readValue(json, (TypeReference)type);
            }
            this.supportType(client);
            if (javaType) {
                return (T)((ObjectMapper)client).readValue(json, (JavaType)type);
            }
            return (T)((ObjectMapper)client).readValue(json, (TypeReference)type);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    protected <C> void supportType(C client) {
        if (!(client instanceof ObjectMapper)) {
            throw new SimpleJsonException("type mismatch");
        }
    }

    protected <type> void supportJavaType(type type) {
        if (!(type instanceof JavaType) && !(type instanceof TypeReference)) {
            throw new SimpleJsonException("java type mismatch");
        }
    }
}

