/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.jsons.support.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.hb0730.jsons.SimpleJsonException;
import com.hb0730.jsons.support.AbstractSimpleJson;
import java.lang.reflect.Type;

public class GsonImpl
extends AbstractSimpleJson {
    private Gson gson;

    public GsonImpl() {
        this(new GsonBuilder().create());
    }

    public GsonImpl(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <C> C getClient() {
        return (C)this.gson;
    }

    @Override
    public <C> void setClient(C client) {
        this.supportType(client);
        this.gson = (Gson)client;
    }

    @Override
    protected <C> String doToJson(Object obj, C client) {
        if (null == client) {
            return this.gson.toJson(obj);
        }
        return ((Gson)client).toJson(obj);
    }

    @Override
    protected <T, C> T doFromJson(String json, Class<T> clazz, C client) {
        if (null == client) {
            return (T)this.gson.fromJson(json, clazz);
        }
        return (T)((Gson)client).fromJson(json, clazz);
    }

    @Override
    protected <T, ValueType, C> T doFromJson(String json, ValueType type, C client) {
        if (null == client) {
            return (T)this.gson.fromJson(json, (Type)type);
        }
        return (T)((Gson)client).fromJson(json, (Type)type);
    }

    @Override
    protected <C> void supportType(C client) {
        if (!(client instanceof Gson)) {
            throw new SimpleJsonException("type mismatch");
        }
    }

    @Override
    protected <ValueType> void supportJavaType(ValueType type) {
        if (!(type instanceof Type)) {
            throw new SimpleJsonException("type mismatch");
        }
    }
}

