/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.jsons.support.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hb0730.jsons.SimpleJsonException;
import com.hb0730.jsons.support.AbstractSimpleJson;

public class JacksonImpl
extends AbstractSimpleJson {
    private ObjectMapper mapper;

    public JacksonImpl() {
        this(new ObjectMapper());
    }

    public JacksonImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public <C> C getClient() {
        return (C)this.mapper;
    }

    @Override
    public <C> void setClient(C client) {
        this.supportType(client);
        this.mapper = (ObjectMapper)client;
    }

    @Override
    protected <C> String doToJson(Object obj, C client) {
        try {
            if (null == client) {
                return this.mapper.writeValueAsString(obj);
            }
            return ((ObjectMapper)client).writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    protected <T, C> T doFromJson(String json, Class<T> clazz, C client) {
        try {
            if (null == client) {
                return (T)this.mapper.readValue(json, clazz);
            }
            return (T)((ObjectMapper)client).readValue(json, clazz);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    protected <T, ValueType, C> T doFromJson(String json, ValueType type, C client) {
        boolean javaType = type instanceof JavaType;
        try {
            if (null == client && javaType) {
                return (T)this.mapper.readValue(json, (JavaType)type);
            }
            if (null == client) {
                return (T)this.mapper.readValue(json, (TypeReference)type);
            }
            if (javaType) {
                return (T)((ObjectMapper)client).readValue(json, (JavaType)type);
            }
            return (T)((ObjectMapper)client).readValue(json, (TypeReference)type);
        }
        catch (Exception e) {
            throw new SimpleJsonException(e);
        }
    }

    @Override
    protected <C> void supportType(C client) {
        if (!(client instanceof ObjectMapper)) {
            throw new SimpleJsonException("type mismatch");
        }
    }

    @Override
    protected <ValueType> void supportJavaType(ValueType type) {
        if (!(type instanceof JavaType) && !(type instanceof TypeReference)) {
            throw new SimpleJsonException("java type mismatch");
        }
    }
}

