/*
 * Decompiled with CFR 0.152.
 */
package com.hbb20;

import android.app.Dialog;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.futuremind.recyclerviewfastscroll.SectionTitleProvider;
import com.hbb20.CCPCountry;
import com.hbb20.CountryCodePicker;
import com.hbb20.R;
import java.util.ArrayList;
import java.util.List;

class CountryCodeAdapter
extends RecyclerView.Adapter<CountryCodeViewHolder>
implements SectionTitleProvider {
    List<CCPCountry> filteredCountries = null;
    List<CCPCountry> masterCountries = null;
    TextView textView_noResult;
    CountryCodePicker codePicker;
    LayoutInflater inflater;
    EditText editText_search;
    Dialog dialog;
    Context context;
    RelativeLayout rlQueryHolder;
    ImageView imgClearQuery;
    int preferredCountriesCount = 0;

    CountryCodeAdapter(Context context, List<CCPCountry> countries, CountryCodePicker codePicker, RelativeLayout rlQueryHolder, EditText editText_search, TextView textView_noResult, Dialog dialog, ImageView imgClearQuery) {
        this.context = context;
        this.masterCountries = countries;
        this.codePicker = codePicker;
        this.dialog = dialog;
        this.textView_noResult = textView_noResult;
        this.editText_search = editText_search;
        this.rlQueryHolder = rlQueryHolder;
        this.imgClearQuery = imgClearQuery;
        this.inflater = LayoutInflater.from((Context)context);
        this.filteredCountries = this.getFilteredCountries("");
        this.setSearchBar();
    }

    private void setSearchBar() {
        if (this.codePicker.isSearchAllowed()) {
            this.imgClearQuery.setVisibility(8);
            this.setTextWatcher();
            this.setQueryClearListener();
        } else {
            this.rlQueryHolder.setVisibility(8);
        }
    }

    private void setQueryClearListener() {
        this.imgClearQuery.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CountryCodeAdapter.this.editText_search.setText((CharSequence)"");
            }
        });
    }

    private void setTextWatcher() {
        if (this.editText_search != null) {
            this.editText_search.addTextChangedListener(new TextWatcher(){

                public void afterTextChanged(Editable s) {
                }

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    CountryCodeAdapter.this.applyQuery(s.toString());
                    if (s.toString().trim().equals("")) {
                        CountryCodeAdapter.this.imgClearQuery.setVisibility(8);
                    } else {
                        CountryCodeAdapter.this.imgClearQuery.setVisibility(0);
                    }
                }
            });
            this.editText_search.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == 3) {
                        InputMethodManager in = (InputMethodManager)CountryCodeAdapter.this.context.getSystemService("input_method");
                        in.hideSoftInputFromWindow(CountryCodeAdapter.this.editText_search.getWindowToken(), 0);
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    private void applyQuery(String query) {
        this.textView_noResult.setVisibility(8);
        query = query.toLowerCase();
        if (query.length() > 0 && query.charAt(0) == '+') {
            query = query.substring(1);
        }
        this.filteredCountries = this.getFilteredCountries(query);
        if (this.filteredCountries.size() == 0) {
            this.textView_noResult.setVisibility(0);
        }
        this.notifyDataSetChanged();
    }

    private List<CCPCountry> getFilteredCountries(String query) {
        ArrayList<CCPCountry> tempCCPCountryList = new ArrayList<CCPCountry>();
        this.preferredCountriesCount = 0;
        if (this.codePicker.preferredCountries != null && this.codePicker.preferredCountries.size() > 0) {
            for (CCPCountry CCPCountry2 : this.codePicker.preferredCountries) {
                if (!CCPCountry2.isEligibleForQuery(query)) continue;
                tempCCPCountryList.add(CCPCountry2);
                ++this.preferredCountriesCount;
            }
            if (tempCCPCountryList.size() > 0) {
                Object divider = null;
                tempCCPCountryList.add((CCPCountry)divider);
                ++this.preferredCountriesCount;
            }
        }
        for (CCPCountry CCPCountry2 : this.masterCountries) {
            if (!CCPCountry2.isEligibleForQuery(query)) continue;
            tempCCPCountryList.add(CCPCountry2);
        }
        return tempCCPCountryList;
    }

    public CountryCodeViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View rootView = this.inflater.inflate(R.layout.layout_recycler_country_tile, viewGroup, false);
        CountryCodeViewHolder viewHolder = new CountryCodeViewHolder(rootView);
        return viewHolder;
    }

    public void onBindViewHolder(CountryCodeViewHolder countryCodeViewHolder, final int i) {
        countryCodeViewHolder.setCountry(this.filteredCountries.get(i));
        if (this.filteredCountries.size() > i && this.filteredCountries.get(i) != null) {
            countryCodeViewHolder.getMainView().setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (CountryCodeAdapter.this.filteredCountries != null && CountryCodeAdapter.this.filteredCountries.size() > i) {
                        CountryCodeAdapter.this.codePicker.onUserTappedCountry(CountryCodeAdapter.this.filteredCountries.get(i));
                    }
                    if (view != null && CountryCodeAdapter.this.filteredCountries != null && CountryCodeAdapter.this.filteredCountries.size() > i && CountryCodeAdapter.this.filteredCountries.get(i) != null) {
                        InputMethodManager imm = (InputMethodManager)CountryCodeAdapter.this.context.getSystemService("input_method");
                        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
                        CountryCodeAdapter.this.dialog.dismiss();
                    }
                }
            });
        } else {
            countryCodeViewHolder.getMainView().setOnClickListener(null);
        }
    }

    public int getItemCount() {
        return this.filteredCountries.size();
    }

    @Override
    public String getSectionTitle(int position) {
        CCPCountry ccpCountry = this.filteredCountries.get(position);
        if (this.preferredCountriesCount > position) {
            return "\u2605";
        }
        if (ccpCountry != null) {
            return ccpCountry.getName().substring(0, 1);
        }
        return "\u263a";
    }

    class CountryCodeViewHolder
    extends RecyclerView.ViewHolder {
        RelativeLayout relativeLayout_main;
        RelativeLayout rootRowCountryTile;
        TextView textView_name;
        TextView textView_code;
        ImageView imageViewFlag;
        LinearLayout linearFlagHolder;
        View divider;

        public CountryCodeViewHolder(View itemView) {
            super(itemView);
            this.relativeLayout_main = (RelativeLayout)itemView;
            this.textView_name = (TextView)this.relativeLayout_main.findViewById(R.id.textView_countryName);
            this.textView_code = (TextView)this.relativeLayout_main.findViewById(R.id.textView_code);
            this.imageViewFlag = (ImageView)this.relativeLayout_main.findViewById(R.id.image_flag);
            this.linearFlagHolder = (LinearLayout)this.relativeLayout_main.findViewById(R.id.linear_flag_holder);
            this.divider = this.relativeLayout_main.findViewById(R.id.preferenceDivider);
            if (CountryCodeAdapter.this.codePicker.getDialogTextColor() != 0) {
                this.textView_name.setTextColor(CountryCodeAdapter.this.codePicker.getDialogTextColor());
                this.textView_code.setTextColor(CountryCodeAdapter.this.codePicker.getDialogTextColor());
                this.divider.setBackgroundColor(CountryCodeAdapter.this.codePicker.getDialogTextColor());
            }
            if (CountryCodeAdapter.this.codePicker.getCcpDialogRippleEnable()) {
                TypedValue outValue = new TypedValue();
                CountryCodeAdapter.this.context.getTheme().resolveAttribute(16843534, outValue, true);
                if (outValue.resourceId != 0) {
                    this.relativeLayout_main.setBackgroundResource(outValue.resourceId);
                } else {
                    this.relativeLayout_main.setBackgroundResource(outValue.data);
                }
            }
            try {
                if (CountryCodeAdapter.this.codePicker.getDialogTypeFace() != null) {
                    if (CountryCodeAdapter.this.codePicker.getDialogTypeFaceStyle() != -99) {
                        this.textView_code.setTypeface(CountryCodeAdapter.this.codePicker.getDialogTypeFace(), CountryCodeAdapter.this.codePicker.getDialogTypeFaceStyle());
                        this.textView_name.setTypeface(CountryCodeAdapter.this.codePicker.getDialogTypeFace(), CountryCodeAdapter.this.codePicker.getDialogTypeFaceStyle());
                    } else {
                        this.textView_code.setTypeface(CountryCodeAdapter.this.codePicker.getDialogTypeFace());
                        this.textView_name.setTypeface(CountryCodeAdapter.this.codePicker.getDialogTypeFace());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setCountry(CCPCountry ccpCountry) {
            if (ccpCountry != null) {
                this.divider.setVisibility(8);
                this.textView_name.setVisibility(0);
                this.textView_code.setVisibility(0);
                if (CountryCodeAdapter.this.codePicker.isCcpDialogShowPhoneCode()) {
                    this.textView_code.setVisibility(0);
                } else {
                    this.textView_code.setVisibility(8);
                }
                String countryName = "";
                if (CountryCodeAdapter.this.codePicker.getCcpDialogShowFlag() && CountryCodeAdapter.this.codePicker.ccpUseEmoji) {
                    countryName = countryName + CCPCountry.getFlagEmoji(ccpCountry) + "   ";
                }
                countryName = countryName + ccpCountry.getName();
                if (CountryCodeAdapter.this.codePicker.getCcpDialogShowNameCode()) {
                    countryName = countryName + " (" + ccpCountry.getNameCode().toUpperCase() + ")";
                }
                this.textView_name.setText((CharSequence)countryName);
                this.textView_code.setText((CharSequence)("+" + ccpCountry.getPhoneCode()));
                if (!CountryCodeAdapter.this.codePicker.getCcpDialogShowFlag() || CountryCodeAdapter.this.codePicker.ccpUseEmoji) {
                    this.linearFlagHolder.setVisibility(8);
                } else {
                    this.linearFlagHolder.setVisibility(0);
                    this.imageViewFlag.setImageResource(ccpCountry.getFlagID());
                }
            } else {
                this.divider.setVisibility(0);
                this.textView_name.setVisibility(8);
                this.textView_code.setVisibility(8);
                this.linearFlagHolder.setVisibility(8);
            }
        }

        public RelativeLayout getMainView() {
            return this.relativeLayout_main;
        }
    }
}

