/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.log.operation.handler;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ArrayUtil;
import com.hccake.ballcat.common.log.operation.handler.OperationLogHandler;
import com.hccake.ballcat.common.util.JsonUtils;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractOperationLogHandler<T>
implements OperationLogHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOperationLogHandler.class);
    private final List<Class<?>> ignoredParamClasses = ListUtil.toList((Object[])new Class[]{ServletRequest.class, ServletResponse.class, MultipartFile.class});

    public void addIgnoredParamClass(Class<?> clazz) {
        this.ignoredParamClasses.add(clazz);
    }

    public String getParams(ProceedingJoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        String strClassName = joinPoint.getTarget().getClass().getName();
        String strMethodName = signature.getName();
        MethodSignature methodSignature = (MethodSignature)signature;
        log.debug("[getParams]\uff0c\u83b7\u53d6\u65b9\u6cd5\u53c2\u6570[\u7c7b\u540d]:{},[\u65b9\u6cd5]:{}", (Object)strClassName, (Object)strMethodName);
        Object[] parameterNames = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        if (ArrayUtil.isEmpty((Object[])parameterNames)) {
            return null;
        }
        HashMap<Object, Object> paramsMap = new HashMap<Object, Object>();
        for (int i = 0; i < parameterNames.length; ++i) {
            Object arg = args[i];
            if (arg == null) {
                paramsMap.put(parameterNames[i], null);
                continue;
            }
            Class<?> argClass = arg.getClass();
            for (Class<?> ignoredParamClass : this.ignoredParamClasses) {
                if (!ignoredParamClass.isAssignableFrom(argClass)) continue;
                arg = "ignored param type: " + argClass;
                break;
            }
            paramsMap.put(parameterNames[i], arg);
        }
        String params = "";
        try {
            params = JsonUtils.toJson(paramsMap);
        }
        catch (Exception e) {
            log.error("[getParams]\uff0c\u83b7\u53d6\u65b9\u6cd5\u53c2\u6570\u5f02\u5e38\uff0c[\u7c7b\u540d]:{},[\u65b9\u6cd5]:{}", new Object[]{strClassName, strMethodName, e});
        }
        return params;
    }
}

