/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.core;

import cn.hutool.core.lang.Assert;
import com.hccake.ballcat.common.redis.config.CachePropertiesHolder;
import com.hccake.ballcat.common.util.SpelUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class KeyGenerator {
    StandardEvaluationContext spelContext;

    public KeyGenerator(Object target, Method method, Object[] arguments) {
        this.spelContext = SpelUtils.getSpelContext((Object)target, (Method)method, (Object[])arguments);
    }

    public String getKey(String keyPrefix, String keyJoint) {
        if (keyJoint == null || keyJoint.length() == 0) {
            return keyPrefix;
        }
        String joint = SpelUtils.parseValueToString((StandardEvaluationContext)this.spelContext, (String)keyJoint);
        Assert.notNull((Object)joint, (String)"Key joint cannot be null!", (Object[])new Object[0]);
        if (!StringUtils.hasText((String)keyPrefix)) {
            return joint;
        }
        return this.jointKey(keyPrefix, joint);
    }

    public List<String> getKeys(String keyPrefix, String keyJoint) {
        Assert.notEmpty((CharSequence)keyJoint, (String)"[getKeys] keyJoint cannot be null", (Object[])new Object[0]);
        List joints = SpelUtils.parseValueToStringList((StandardEvaluationContext)this.spelContext, (String)keyJoint);
        Assert.notEmpty((Iterable)joints, (String)"[getKeys] keyJoint must be resolved to a non-empty collection!", (Object[])new Object[0]);
        if (!StringUtils.hasText((String)keyPrefix)) {
            return joints;
        }
        return joints.stream().map(x -> this.jointKey(keyPrefix, (String)x)).collect(Collectors.toList());
    }

    public String jointKey(List<String> keyItems) {
        return String.join((CharSequence)CachePropertiesHolder.delimiter(), keyItems);
    }

    public String jointKey(String ... keyItems) {
        return this.jointKey(Arrays.asList(keyItems));
    }
}

