/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.keyevent.listener;

import com.hccake.ballcat.common.redis.keyevent.listener.AbstractDeletedKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.template.KeyDeletedEventMessageTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.util.CollectionUtils;

public class DefaultDeletedKeyEventMessageListener
extends AbstractDeletedKeyEventMessageListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeletedKeyEventMessageListener.class);
    protected List<KeyDeletedEventMessageTemplate> keyDeletedEventMessageTemplates;

    public DefaultDeletedKeyEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public DefaultDeletedKeyEventMessageListener(RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeyDeletedEventMessageTemplate>> objectProvider) {
        super(listenerContainer);
        objectProvider.ifAvailable(templates -> {
            this.keyDeletedEventMessageTemplates = new ArrayList<KeyDeletedEventMessageTemplate>((Collection<KeyDeletedEventMessageTemplate>)templates);
        });
    }

    public void onMessage(Message message, byte[] pattern) {
        if (CollectionUtils.isEmpty(this.keyDeletedEventMessageTemplates)) {
            return;
        }
        super.onMessage(message, pattern);
        String setKey = message.toString();
        for (KeyDeletedEventMessageTemplate keyDeletedEventMessageTemplate : this.keyDeletedEventMessageTemplates) {
            if (!keyDeletedEventMessageTemplate.support(setKey)) continue;
            if (log.isTraceEnabled()) {
                log.trace("use template [{}] handle key deleted event,the deleted key is [{}]", (Object)keyDeletedEventMessageTemplate.getClass().getName(), (Object)setKey);
            }
            keyDeletedEventMessageTemplate.handleMessage(setKey);
        }
    }
}

