/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.keyevent.listener;

import com.hccake.ballcat.common.redis.keyevent.listener.AbstractSetKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.template.KeySetEventMessageTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.util.CollectionUtils;

public class DefaultSetKeyEventMessageListener
extends AbstractSetKeyEventMessageListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultSetKeyEventMessageListener.class);
    protected List<KeySetEventMessageTemplate> keySetEventMessageTemplates;

    public DefaultSetKeyEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public DefaultSetKeyEventMessageListener(RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeySetEventMessageTemplate>> objectProvider) {
        super(listenerContainer);
        objectProvider.ifAvailable(templates -> {
            this.keySetEventMessageTemplates = new ArrayList<KeySetEventMessageTemplate>((Collection<KeySetEventMessageTemplate>)templates);
        });
    }

    public void onMessage(Message message, byte[] pattern) {
        if (CollectionUtils.isEmpty(this.keySetEventMessageTemplates)) {
            return;
        }
        super.onMessage(message, pattern);
        String setKey = message.toString();
        for (KeySetEventMessageTemplate keySetEventMessageTemplate : this.keySetEventMessageTemplates) {
            if (!keySetEventMessageTemplate.support(setKey)) continue;
            if (log.isTraceEnabled()) {
                log.trace("use template[{}]handle key set event,the set key is[{}]", (Object)keySetEventMessageTemplate.getClass().getName(), (Object)setKey);
            }
            keySetEventMessageTemplate.handleMessage(setKey);
        }
    }
}

