/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.lock;

import com.hccake.ballcat.common.redis.RedisHelper;
import com.hccake.ballcat.common.redis.config.CachePropertiesHolder;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public final class CacheLock {
    private static final Logger log = LoggerFactory.getLogger(CacheLock.class);
    private static final DefaultRedisScript<Long> RELEASE_LOCK_LUA_SCRIPT = new DefaultRedisScript("if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end", Long.class);
    private static final Long RELEASE_LOCK_SUCCESS_RESULT = 1L;

    private CacheLock() {
    }

    public static Boolean lock(String lockKey, String requestId) {
        return CacheLock.lock(lockKey, requestId, CachePropertiesHolder.defaultLockTimeout(), TimeUnit.SECONDS);
    }

    public static Boolean lock(String lockKey, String requestId, long timeout) {
        return CacheLock.lock(lockKey, requestId, timeout, TimeUnit.SECONDS);
    }

    public static Boolean lock(String lockKey, String requestId, long timeout, TimeUnit timeUnit) {
        if (log.isTraceEnabled()) {
            log.trace("lock: {key:{}, clientId:{}}", (Object)lockKey, (Object)requestId);
        }
        return RedisHelper.setNxEx(lockKey, requestId, timeout, timeUnit);
    }

    public static boolean releaseLock(String key, String requestId) {
        if (log.isTraceEnabled()) {
            log.trace("release lock: {key:{}, clientId:{}}", (Object)key, (Object)requestId);
        }
        Long result = RedisHelper.execute(RELEASE_LOCK_LUA_SCRIPT, Collections.singletonList(key), new Object[]{requestId});
        return Objects.equals(result, RELEASE_LOCK_SUCCESS_RESULT);
    }
}

