/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.prefix;

import cn.hutool.core.text.CharSequenceUtil;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IRedisPrefixConverter {
    public static final Logger LOGGER = LoggerFactory.getLogger(IRedisPrefixConverter.class);

    public String getPrefix();

    public boolean match();

    default public byte[] unwrap(byte[] bytes) {
        int wrapLen;
        if (!this.match() || bytes == null || (wrapLen = bytes.length) == 0) {
            return bytes;
        }
        String prefix = this.getPrefix();
        if (CharSequenceUtil.isBlank((CharSequence)prefix)) {
            LOGGER.warn("prefix converter is enabled,but method getPrefix returns blank result,check your implement!");
            return bytes;
        }
        byte[] prefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        int prefixLen = prefixBytes.length;
        int originLen = wrapLen - prefixLen;
        byte[] originBytes = new byte[originLen];
        System.arraycopy(bytes, prefixLen, originBytes, 0, originLen);
        return originBytes;
    }

    default public byte[] wrap(byte[] bytes) {
        int originLen;
        if (!this.match() || bytes == null || (originLen = bytes.length) == 0) {
            return bytes;
        }
        String prefix = this.getPrefix();
        if (CharSequenceUtil.isBlank((CharSequence)prefix)) {
            LOGGER.warn("prefix converter is enabled,but method getPrefix returns blank result,check your implement!");
            return bytes;
        }
        byte[] prefixBytes = prefix.getBytes(StandardCharsets.UTF_8);
        int prefixLen = prefixBytes.length;
        byte[] wrapBytes = new byte[prefixLen + originLen];
        System.arraycopy(prefixBytes, 0, wrapBytes, 0, prefixLen);
        System.arraycopy(bytes, 0, wrapBytes, prefixLen, originLen);
        return wrapBytes;
    }
}

