/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.serialize;

import com.hccake.ballcat.common.redis.prefix.IRedisPrefixConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;

public class PrefixJdkRedisSerializer
extends JdkSerializationRedisSerializer {
    private static final Logger log = LoggerFactory.getLogger(PrefixJdkRedisSerializer.class);
    private final IRedisPrefixConverter redisPrefixConverter;

    public PrefixJdkRedisSerializer(IRedisPrefixConverter redisPrefixConverter) {
        this.redisPrefixConverter = redisPrefixConverter;
    }

    public Object deserialize(byte[] bytes) {
        byte[] unwrap = this.redisPrefixConverter.unwrap(bytes);
        return super.deserialize(unwrap);
    }

    public byte[] serialize(Object object) {
        byte[] originBytes = super.serialize(object);
        return this.redisPrefixConverter.wrap(originBytes);
    }
}

