/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.serialize;

import com.hccake.ballcat.common.redis.prefix.IRedisPrefixConverter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class PrefixStringRedisSerializer
extends StringRedisSerializer {
    private static final Logger log = LoggerFactory.getLogger(PrefixStringRedisSerializer.class);
    private final IRedisPrefixConverter iRedisPrefixConverter;

    public PrefixStringRedisSerializer(IRedisPrefixConverter iRedisPrefixConverter) {
        super(StandardCharsets.UTF_8);
        this.iRedisPrefixConverter = iRedisPrefixConverter;
    }

    public String deserialize(byte[] bytes) {
        byte[] unwrap = this.iRedisPrefixConverter.unwrap(bytes);
        return super.deserialize(unwrap);
    }

    public byte[] serialize(String key) {
        byte[] originBytes = super.serialize(key);
        return this.iRedisPrefixConverter.wrap(originBytes);
    }
}

