/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket.distribute;

import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.common.websocket.distribute.AbstractMessageDistributor;
import com.hccake.ballcat.common.websocket.distribute.MessageDO;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisMessageDistributor
extends AbstractMessageDistributor
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RedisMessageDistributor.class);
    public static final String CHANNEL = "websocket-send";
    private final StringRedisTemplate stringRedisTemplate;

    public RedisMessageDistributor(WebSocketSessionStore webSocketSessionStore, StringRedisTemplate stringRedisTemplate) {
        super(webSocketSessionStore);
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void distribute(MessageDO messageDO) {
        String str = JsonUtils.toJson((Object)messageDO);
        this.stringRedisTemplate.convertAndSend(CHANNEL, (Object)str);
    }

    public void onMessage(Message message, byte[] bytes) {
        log.info("redis channel Listener message send {}", (Object)message);
        byte[] channelBytes = message.getChannel();
        RedisSerializer stringSerializer = this.stringRedisTemplate.getStringSerializer();
        String channel = (String)stringSerializer.deserialize(channelBytes);
        if (CHANNEL.equals(channel)) {
            byte[] bodyBytes = message.getBody();
            String body = (String)stringSerializer.deserialize(bodyBytes);
            MessageDO messageDO = (MessageDO)JsonUtils.toObj((String)body, MessageDO.class);
            this.doSend(messageDO);
        }
    }
}

