/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket.handler;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hccake.ballcat.common.websocket.exception.ErrorJsonMessageException;
import com.hccake.ballcat.common.websocket.handler.JsonMessageHandler;
import com.hccake.ballcat.common.websocket.handler.PlanTextMessageHandler;
import com.hccake.ballcat.common.websocket.holder.JsonMessageHandlerHolder;
import com.hccake.ballcat.common.websocket.message.JsonWebSocketMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class CustomWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomWebSocketHandler.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private PlanTextMessageHandler planTextMessageHandler;

    public CustomWebSocketHandler() {
    }

    public CustomWebSocketHandler(PlanTextMessageHandler planTextMessageHandler) {
        this.planTextMessageHandler = planTextMessageHandler;
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) {
        if (message.getPayloadLength() == 0) {
            return;
        }
        String payload = (String)message.getPayload();
        try {
            this.handleWithJson(session, payload);
        }
        catch (ErrorJsonMessageException ex) {
            log.debug("\u6d88\u606f\u8f7d\u8377 [{}] \u56de\u9000\u4f7f\u7528 PlanTextMessageHandler\uff0c\u539f\u56e0\uff1a{}", (Object)payload, (Object)ex.getMessage());
            if (this.planTextMessageHandler != null) {
                this.planTextMessageHandler.handle(session, payload);
            }
            log.error("[handleTextMessage] \u666e\u901a\u6587\u672c\u6d88\u606f\uff08{}\uff09\u6ca1\u6709\u5bf9\u5e94\u7684\u6d88\u606f\u5904\u7406\u5668", (Object)payload);
        }
    }

    private void handleWithJson(WebSocketSession session, String payload) {
        JsonWebSocketMessage websocketMessageJson;
        JsonNode jsonNode = null;
        try {
            jsonNode = MAPPER.readTree(payload);
        }
        catch (JsonProcessingException e) {
            throw new ErrorJsonMessageException("json \u89e3\u6790\u5f02\u5e38");
        }
        if (!jsonNode.isObject()) {
            throw new ErrorJsonMessageException("json \u683c\u5f0f\u5f02\u5e38\uff01\u975e object \u7c7b\u578b\uff01");
        }
        JsonNode typeNode = jsonNode.get("type");
        String messageType = typeNode.asText();
        if (messageType == null) {
            throw new ErrorJsonMessageException("json \u65e0 type \u5c5e\u6027");
        }
        JsonMessageHandler<JsonWebSocketMessage> jsonMessageHandler = JsonMessageHandlerHolder.getHandler(messageType);
        if (jsonMessageHandler == null) {
            log.error("[handleTextMessage] \u6d88\u606f\u7c7b\u578b\uff08{}\uff09\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6d88\u606f\u5904\u7406\u5668", (Object)messageType);
            return;
        }
        Class<JsonWebSocketMessage> messageClass = jsonMessageHandler.getMessageClass();
        try {
            websocketMessageJson = (JsonWebSocketMessage)MAPPER.treeToValue((TreeNode)jsonNode, messageClass);
        }
        catch (JsonProcessingException e) {
            throw new ErrorJsonMessageException("\u6d88\u606f\u5e8f\u5217\u5316\u5f02\u5e38\uff0cclass " + messageClass);
        }
        jsonMessageHandler.handle(session, websocketMessageJson);
    }

    static {
        MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
    }
}

