/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.websocket.session;

import com.hccake.ballcat.common.websocket.session.SessionKeyGenerator;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class DefaultWebSocketSessionStore
implements WebSocketSessionStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSocketSessionStore.class);
    private final SessionKeyGenerator sessionKeyGenerator;
    private final ConcurrentHashMap<Object, Map<String, WebSocketSession>> sessionKeyToWsSessions = new ConcurrentHashMap();

    public DefaultWebSocketSessionStore(SessionKeyGenerator sessionKeyGenerator) {
        this.sessionKeyGenerator = sessionKeyGenerator;
    }

    @Override
    public void addSession(WebSocketSession wsSession) {
        Object sessionKey = this.sessionKeyGenerator.sessionKey(wsSession);
        Map<String, WebSocketSession> sessions = this.sessionKeyToWsSessions.get(sessionKey);
        if (sessions == null) {
            sessions = new ConcurrentHashMap<String, WebSocketSession>();
            this.sessionKeyToWsSessions.putIfAbsent(sessionKey, sessions);
            sessions = this.sessionKeyToWsSessions.get(sessionKey);
        }
        sessions.put(wsSession.getId(), wsSession);
    }

    @Override
    public void removeSession(WebSocketSession session) {
        Object sessionKey = this.sessionKeyGenerator.sessionKey(session);
        String wsSessionId = session.getId();
        Map<String, WebSocketSession> sessions = this.sessionKeyToWsSessions.get(sessionKey);
        if (sessions != null) {
            boolean result;
            boolean bl = result = sessions.remove(wsSessionId) != null;
            if (log.isDebugEnabled()) {
                log.debug("Removal of " + wsSessionId + " was " + result);
            }
            if (sessions.isEmpty()) {
                this.sessionKeyToWsSessions.remove(sessionKey);
                if (log.isDebugEnabled()) {
                    log.debug("Removed the corresponding HTTP Session for " + wsSessionId + " since it contained no WebSocket mappings");
                }
            }
        }
    }

    @Override
    public Collection<WebSocketSession> getSessions() {
        return this.sessionKeyToWsSessions.values().stream().flatMap(x -> x.values().stream()).collect(Collectors.toList());
    }

    @Override
    public Collection<WebSocketSession> getSessions(Object sessionKey) {
        Map<String, WebSocketSession> sessions = this.sessionKeyToWsSessions.get(sessionKey);
        if (sessions == null) {
            log.warn("\u6839\u636e\u6307\u5b9a\u7684sessionKey: {} \u83b7\u53d6\u5bf9\u5e94\u7684wsSessions\u4e3a\u7a7a!", sessionKey);
            return Collections.emptyList();
        }
        return sessions.values();
    }

    @Override
    public Collection<Object> getSessionKeys() {
        return this.sessionKeyToWsSessions.keySet();
    }
}

