/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.extend.dingtalk;

import cn.hutool.core.convert.Convert;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public class DingTalkResponse {
    public static final Long SUCCESS_CODE = 0L;
    private Long code;
    private String message;
    private String response;
    private boolean success;

    public DingTalkResponse(String res) {
        Map resMap = (Map)new ObjectMapper().readValue(res.getBytes(), Map.class);
        this.response = res;
        this.code = Convert.toLong(resMap.get("errcode"));
        this.message = Convert.toStr(resMap.get("errmsg"));
        this.success = SUCCESS_CODE.equals(this.code);
    }

    public static DingTalkResponse of(String res) {
        return new DingTalkResponse(res);
    }

    public String toString() {
        return this.response;
    }

    public Long getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public DingTalkResponse setCode(Long code) {
        this.code = code;
        return this;
    }

    public DingTalkResponse setMessage(String message) {
        this.message = message;
        return this;
    }

    public DingTalkResponse setResponse(String response) {
        this.response = response;
        return this;
    }

    public DingTalkResponse setSuccess(boolean success) {
        this.success = success;
        return this;
    }
}

