/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.extend.dingtalk;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.extend.dingtalk.DingTalkResponse;
import com.hccake.extend.dingtalk.message.DingTalkMessage;
import com.sun.nio.sctp.IllegalReceiveException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.util.StringUtils;

public class DingTalkSender {
    private static final OkHttpClient HTTP_CLIENT = new OkHttpClient.Builder().build();
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json");
    private OkHttpClient client = HTTP_CLIENT;
    private final String url;
    private String secret;
    private final Mac mac;

    public DingTalkSender(String url) {
        this.url = url;
        this.mac = Mac.getInstance("HmacSHA256");
    }

    public DingTalkResponse sendMessage(DingTalkMessage message) {
        if (CharSequenceUtil.isEmpty((CharSequence)this.secret)) {
            return this.sendNormalMessage(message);
        }
        return this.sendSecretMessage(message);
    }

    public DingTalkResponse sendNormalMessage(DingTalkMessage message) {
        return this.request(message, false);
    }

    public DingTalkResponse sendSecretMessage(DingTalkMessage message) {
        return this.request(message, true);
    }

    public DingTalkSender setSecret(String secret) {
        if (StringUtils.hasText((String)secret)) {
            this.secret = secret;
            this.mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
        }
        return this;
    }

    public String secret(long timestamp) {
        byte[] secretBytes = (timestamp + "\n" + this.secret).getBytes(StandardCharsets.UTF_8);
        String secretBase64 = Base64.encode((byte[])this.mac.doFinal(secretBytes));
        String sign = URLEncoder.encode(secretBase64, "UTF-8");
        return String.format("%s&timestamp=%s&sign=%s", this.url, timestamp, sign);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DingTalkResponse request(DingTalkMessage dingTalkMessage, boolean isSecret) {
        String message = dingTalkMessage.generate();
        String requestUrl = isSecret ? this.secret(System.currentTimeMillis()) : this.getUrl();
        RequestBody requestBody = RequestBody.create((String)message, (MediaType)MEDIA_TYPE);
        Request request = new Request.Builder().url(requestUrl).post(requestBody).build();
        Call call = this.client.newCall(request);
        try (Response response = call.execute();){
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new IllegalReceiveException("\u9489\u9489\u53d1\u9001\u6d88\u606f\u63a5\u53e3\u8fd4\u56de\u503c\u4e3a null!");
            }
            String dingTalkResponse = responseBody.string();
            DingTalkResponse dingTalkResponse2 = DingTalkResponse.of(dingTalkResponse);
            return dingTalkResponse2;
        }
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSecret() {
        return this.secret;
    }

    public Mac getMac() {
        return this.mac;
    }

    public DingTalkSender setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }
}

