/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.extend.dingtalk.message;

import com.hccake.ballcat.common.core.markdown.MarkdownBuilder;
import com.hccake.extend.dingtalk.DingTalkParams;
import com.hccake.extend.dingtalk.enums.ActionBtnOrientationEnum;
import com.hccake.extend.dingtalk.enums.MessageTypeEnum;
import com.hccake.extend.dingtalk.message.AbstractDingTalkMessage;
import java.util.ArrayList;
import java.util.List;

public class DingTalkActionCardMessage
extends AbstractDingTalkMessage {
    private String title;
    private MarkdownBuilder text;
    private ActionBtnOrientationEnum orientation = ActionBtnOrientationEnum.HORIZONTAL;
    private String singleTitle;
    private String singleUrl;
    private List<Button> buttons = new ArrayList<Button>();

    public DingTalkActionCardMessage addButton(String title, String url) {
        this.buttons.add(new Button(title, url));
        return this;
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.ACTION_CARD;
    }

    @Override
    public DingTalkParams put(DingTalkParams params) {
        DingTalkParams.ActionCard card = new DingTalkParams.ActionCard().setTitle(this.title).setText(this.text.build()).setBtnOrientation(this.orientation.getVal());
        if (this.buttons.isEmpty()) {
            card.setSingleTitle(this.singleTitle).setSingleUrl(this.singleUrl);
        } else {
            card.setButtons(this.buttons);
        }
        return params.setActionCard(card);
    }

    public String getTitle() {
        return this.title;
    }

    public MarkdownBuilder getText() {
        return this.text;
    }

    public ActionBtnOrientationEnum getOrientation() {
        return this.orientation;
    }

    public String getSingleTitle() {
        return this.singleTitle;
    }

    public String getSingleUrl() {
        return this.singleUrl;
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public DingTalkActionCardMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public DingTalkActionCardMessage setText(MarkdownBuilder text) {
        this.text = text;
        return this;
    }

    public DingTalkActionCardMessage setOrientation(ActionBtnOrientationEnum orientation) {
        this.orientation = orientation;
        return this;
    }

    public DingTalkActionCardMessage setSingleTitle(String singleTitle) {
        this.singleTitle = singleTitle;
        return this;
    }

    public DingTalkActionCardMessage setSingleUrl(String singleUrl) {
        this.singleUrl = singleUrl;
        return this;
    }

    public DingTalkActionCardMessage setButtons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    public static class Button {
        private final String title;
        private final String actionURL;

        public String getTitle() {
            return this.title;
        }

        public String getActionURL() {
            return this.actionURL;
        }

        public Button(String title, String actionURL) {
            this.title = title;
            this.actionURL = actionURL;
        }
    }
}

