/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.extend.pay.wx;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.extend.pay.wx.constants.WxPayConstant;
import com.hccake.extend.pay.wx.domain.DefaultWxDomain;
import com.hccake.extend.pay.wx.domain.WxDomain;
import com.hccake.extend.pay.wx.enums.RequestSuffix;
import com.hccake.extend.pay.wx.enums.SignType;
import com.hccake.extend.pay.wx.enums.TradeType;
import com.hccake.extend.pay.wx.response.WxPayCallback;
import com.hccake.extend.pay.wx.response.WxPayOrderQueryResponse;
import com.hccake.extend.pay.wx.response.WxPayResponse;
import com.hccake.extend.pay.wx.utils.WxPayUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class WxPay {
    private final String appId;
    private final String mchId;
    private final String mckKey;
    private String notifyUrl;
    private String returnUrl;
    private boolean sandbox;
    private WxDomain domain;

    public WxPay(String appId, String mchId, String mckKey, boolean sandbox) {
        this(appId, mchId, mckKey, sandbox, DefaultWxDomain.of(sandbox));
    }

    public WxPay(String appId, String mchId, String mckKey, boolean sandbox, WxDomain domain) {
        this.sandbox = sandbox;
        this.domain = domain;
        this.mchId = mchId;
        this.appId = appId;
        this.mckKey = sandbox ? domain.sandbox(this).getSandboxSignKey() : mckKey;
    }

    public WxPayResponse jsApiPay(String sn, BigDecimal amount, String ip, String body) {
        return this.jsApiPay(sn, amount, ip, body, this.notifyUrl);
    }

    public WxPayResponse jsApiPay(String sn, BigDecimal amount, String ip, String body, String notifyUrl) {
        return WxPayResponse.of(this.pay(sn, amount, ip, body, notifyUrl, TradeType.JSAPI));
    }

    public WxPayResponse appPay(String sn, BigDecimal amount, String ip, String body) {
        return this.appPay(sn, amount, ip, body, this.notifyUrl);
    }

    public WxPayResponse appPay(String sn, BigDecimal amount, String ip, String body, String notifyUrl) {
        return WxPayResponse.of(this.pay(sn, amount, ip, body, notifyUrl, TradeType.APP));
    }

    public WxPayResponse nativePay(String sn, BigDecimal amount, String body) {
        return this.nativePay(sn, amount, body, this.notifyUrl);
    }

    public WxPayResponse nativePay(String sn, BigDecimal amount, String body, String notifyUrl) {
        return WxPayResponse.of(this.pay(sn, amount, null, body, notifyUrl, TradeType.NATIVE));
    }

    public WxPayResponse webPay(String sn, BigDecimal amount, String ip, String body) {
        return this.webPay(sn, amount, ip, body, this.notifyUrl);
    }

    public WxPayResponse webPay(String sn, BigDecimal amount, String ip, String body, String notifyUrl) {
        return WxPayResponse.of(this.pay(sn, amount, ip, body, notifyUrl, TradeType.MWEB));
    }

    public Map<String, String> pay(String sn, BigDecimal amount, String ip, String body, String notifyUrl, TradeType tradeType) {
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("body", body);
        params.put("out_trade_no", sn);
        params.put("total_fee", this.yuanToFen(amount));
        params.put("spbill_create_ip", ip);
        params.put("notify_url", notifyUrl);
        params.put("trade_type", tradeType.toString());
        return this.request(params, RequestSuffix.UNIFIEDORDER);
    }

    public WxPayOrderQueryResponse query(String sn, String wxSn) {
        Assert.isFalse((CharSequenceUtil.isBlank((CharSequence)sn) && CharSequenceUtil.isBlank((CharSequence)wxSn) ? 1 : 0) != 0, (String)"\u53c2\u6570 sn \u548c wxSn \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a!", (Object[])new Object[0]);
        HashMap<String, String> params = new HashMap<String, String>(6);
        params.put("out_trade_no", sn);
        params.put("transaction_id", wxSn);
        return WxPayOrderQueryResponse.of(this.request(params, RequestSuffix.ORDERQUERY));
    }

    public Map<String, String> request(Map<String, String> params, RequestSuffix rs) {
        HashMap<String, String> map = new HashMap<String, String>(params.size() + 3);
        map.putAll(params);
        map.put("appid", this.appId);
        map.put("mch_id", this.mchId);
        map.put("nonce_str", WxPayUtil.generateNonceStr());
        map.put("sign_type", this.sandbox ? SignType.MD5.getStr() : SignType.HMAC_SHA256.getStr());
        map.put("sign", WxPayUtil.sign(map, this.mckKey));
        return this.domain.request(map, rs);
    }

    public String yuanToFen(BigDecimal amount) {
        return amount.multiply(WxPayConstant.HUNDRED).setScale(2, RoundingMode.UP).toBigInteger().toString();
    }

    public boolean checkSign(WxPayCallback callback) {
        if (CharSequenceUtil.isBlank((CharSequence)callback.getSign())) {
            return false;
        }
        HashMap<String, String> params = new HashMap<String, String>(callback.getRaw());
        if (params.containsKey("sign_type")) {
            return WxPayUtil.sign(params, this.mckKey).equals(callback.getSign());
        }
        if (WxPayUtil.sign(params, SignType.HMAC_SHA256, this.mckKey).equals(callback.getSign())) {
            return true;
        }
        return WxPayUtil.sign(params, SignType.MD5, this.mckKey).equals(callback.getSign());
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMchId() {
        return this.mchId;
    }

    public String getMckKey() {
        return this.mckKey;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    public WxDomain getDomain() {
        return this.domain;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public void setSandbox(boolean sandbox) {
        this.sandbox = sandbox;
    }

    public void setDomain(WxDomain domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPay)) {
            return false;
        }
        WxPay other = (WxPay)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSandbox() != other.isSandbox()) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$mchId = this.getMchId();
        String other$mchId = other.getMchId();
        if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
            return false;
        }
        String this$mckKey = this.getMckKey();
        String other$mckKey = other.getMckKey();
        if (this$mckKey == null ? other$mckKey != null : !this$mckKey.equals(other$mckKey)) {
            return false;
        }
        String this$notifyUrl = this.getNotifyUrl();
        String other$notifyUrl = other.getNotifyUrl();
        if (this$notifyUrl == null ? other$notifyUrl != null : !this$notifyUrl.equals(other$notifyUrl)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
            return false;
        }
        WxDomain this$domain = this.getDomain();
        WxDomain other$domain = other.getDomain();
        return !(this$domain == null ? other$domain != null : !this$domain.equals(other$domain));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPay;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSandbox() ? 79 : 97);
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $mchId = this.getMchId();
        result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
        String $mckKey = this.getMckKey();
        result = result * 59 + ($mckKey == null ? 43 : $mckKey.hashCode());
        String $notifyUrl = this.getNotifyUrl();
        result = result * 59 + ($notifyUrl == null ? 43 : $notifyUrl.hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        WxDomain $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        return result;
    }

    public String toString() {
        return "WxPay(appId=" + this.getAppId() + ", mchId=" + this.getMchId() + ", mckKey=" + this.getMckKey() + ", notifyUrl=" + this.getNotifyUrl() + ", returnUrl=" + this.getReturnUrl() + ", sandbox=" + this.isSandbox() + ", domain=" + this.getDomain() + ")";
    }
}

