/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.extend.pay.wx.utils;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.RandomUtil;
import com.hccake.extend.pay.wx.enums.SignType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class WxPayUtil {
    private static final Logger log = LoggerFactory.getLogger(WxPayUtil.class);

    private WxPayUtil() {
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        return factory.newDocumentBuilder();
    }

    public static Document getDocument() throws ParserConfigurationException {
        return WxPayUtil.getDocumentBuilder().newDocument();
    }

    public static String mapToXml(Map<String, String> data) throws ParserConfigurationException, TransformerException {
        Document document = WxPayUtil.getDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(entry.getKey());
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(document), result);
        String output = writer.getBuffer().toString();
        try {
            writer.close();
        }
        catch (Exception ex) {
            log.error("string \u5199\u5165\u6d41\u5173\u95ed\u5f02\u5e38");
        }
        return output;
    }

    public static Map<String, String> xmlToMap(String xml) throws ParserConfigurationException, IOException, SAXException {
        HashMap<String, String> data = new HashMap<String, String>(30);
        ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
        Document doc = WxPayUtil.getDocumentBuilder().parse(stream);
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getDocumentElement().getChildNodes();
        for (int idx = 0; idx < nodeList.getLength(); ++idx) {
            Node node = nodeList.item(idx);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            data.put(element.getNodeName(), element.getTextContent());
        }
        try {
            ((InputStream)stream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static String sign(Map<String, String> params, String mckKey) {
        SignType st = SignType.of(params.get("sign_type"));
        Assert.isFalse((st == null ? 1 : 0) != 0, (String)"\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        return WxPayUtil.sign(params, st, mckKey);
    }

    public static String sign(Map<String, String> params, SignType type, String mckKey) {
        byte[] bytes;
        Object[] keyArray = params.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        StringBuilder paramsStr = new StringBuilder();
        for (Object k : keyArray) {
            String val;
            if (((String)k).equals("sign") || !CharSequenceUtil.isNotBlank((CharSequence)(val = params.get(k)))) continue;
            paramsStr.append((String)k).append("=").append(val.trim()).append("&");
        }
        paramsStr.append("key=").append(mckKey);
        if (type == SignType.MD5) {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            bytes = md5.digest(paramsStr.toString().getBytes(StandardCharsets.UTF_8));
        } else {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec sk = new SecretKeySpec(mckKey.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            mac.init(sk);
            bytes = mac.doFinal(paramsStr.toString().getBytes(StandardCharsets.UTF_8));
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(Integer.toHexString(b & 0xFF | 0x100), 1, 3);
        }
        return builder.toString().toUpperCase();
    }

    public static String generateNonceStr() {
        return RandomUtil.randomString((int)16);
    }
}

