/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.i18n.mapper;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.i18n.converter.I18nDataConverter;
import com.hccake.ballcat.i18n.model.dto.I18nDataDTO;
import com.hccake.ballcat.i18n.model.entity.I18nData;
import com.hccake.ballcat.i18n.model.qo.I18nDataQO;
import com.hccake.ballcat.i18n.model.vo.I18nDataPageVO;
import com.hccake.extend.mybatis.plus.conditions.query.LambdaQueryWrapperX;
import com.hccake.extend.mybatis.plus.mapper.ExtendMapper;
import com.hccake.extend.mybatis.plus.toolkit.WrappersX;
import java.util.List;

public interface I18nDataMapper
extends ExtendMapper<I18nData> {
    default public PageResult<I18nDataPageVO> queryPage(PageParam pageParam, I18nDataQO qo) {
        IPage page = this.prodPage(pageParam);
        Wrapper<I18nData> wrapper = this.buildQueryWrapper(qo);
        this.selectPage(page, wrapper);
        IPage voPage = page.convert(arg_0 -> ((I18nDataConverter)I18nDataConverter.INSTANCE).poToPageVo(arg_0));
        return new PageResult(voPage.getRecords(), voPage.getTotal());
    }

    default public Wrapper<I18nData> buildQueryWrapper(I18nDataQO qo) {
        LambdaQueryWrapperX wrapper = WrappersX.lambdaQueryX(I18nData.class);
        wrapper.likeIfPresent(I18nData::getCode, (Object)qo.getCode()).likeIfPresent(I18nData::getMessage, (Object)qo.getMessage()).eqIfPresent(I18nData::getLanguageTag, (Object)qo.getLanguageTag());
        return wrapper;
    }

    default public List<I18nData> queryList(I18nDataQO i18nDataQO) {
        Wrapper<I18nData> wrapper = this.buildQueryWrapper(i18nDataQO);
        return this.selectList(wrapper);
    }

    default public List<I18nData> listByCode(String code) {
        Wrapper wrapper = (Wrapper)Wrappers.lambdaQuery(I18nData.class).eq(I18nData::getCode, (Object)code);
        return this.selectList(wrapper);
    }

    default public I18nData selectByCodeAndLanguageTag(String code, String languageTag) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(I18nData.class).eq(I18nData::getCode, (Object)code)).eq(I18nData::getLanguageTag, (Object)languageTag);
        return (I18nData)this.selectOne((Wrapper)wrapper);
    }

    default public boolean updateByCodeAndLanguageTag(I18nDataDTO i18nDataDTO) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(I18nData.class).eq(I18nData::getCode, (Object)i18nDataDTO.getCode())).eq(I18nData::getLanguageTag, (Object)i18nDataDTO.getLanguageTag());
        I18nData entity = new I18nData();
        entity.setMessage(i18nDataDTO.getMessage());
        entity.setRemarks(i18nDataDTO.getRemarks());
        return SqlHelper.retBool((Integer)this.update(entity, (Wrapper)wrapper));
    }

    default public boolean deleteByCodeAndLanguageTag(String code, String languageTag) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(I18nData.class).eq(I18nData::getCode, (Object)code)).eq(I18nData::getLanguageTag, (Object)languageTag);
        return SqlHelper.retBool((Integer)this.delete((Wrapper)wrapper));
    }

    default public List<I18nData> exists(List<I18nData> list) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery(I18nData.class);
        for (I18nData i18nData : list) {
            wrapper.or(w -> {
                String code = i18nData.getCode();
                String languageTag = i18nData.getLanguageTag();
                ((LambdaQueryWrapper)w.eq(I18nData::getCode, (Object)code)).eq(I18nData::getLanguageTag, (Object)languageTag);
            });
        }
        return this.selectList((Wrapper)wrapper);
    }
}

