/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.i18n.provider;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.util.RandomUtil;
import com.hccake.ballcat.common.i18n.I18nMessage;
import com.hccake.ballcat.common.i18n.I18nMessageProvider;
import com.hccake.ballcat.common.redis.listener.AbstractMessageEventListener;
import com.hccake.ballcat.i18n.model.dto.I18nDataUnique;
import com.hccake.ballcat.i18n.model.entity.I18nData;
import com.hccake.ballcat.i18n.service.I18nDataService;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.Topic;

public class CustomI18nMessageProvider
extends AbstractMessageEventListener<I18nDataUnique>
implements I18nMessageProvider {
    private final I18nDataService i18nDataService;
    private final TimedCache<String, I18nMessage> cache;
    private static final int MILLISECONDS_OF_HOUR = 3600000;
    private static final int MIN_TIMEOUT = 3240000;
    private static final int MAX_TIMEOUT = 3960000;

    public CustomI18nMessageProvider(I18nDataService i18nDataService) {
        this.i18nDataService = i18nDataService;
        this.cache = new TimedCache(3600000L, new ConcurrentHashMap());
        this.cache.schedulePrune(1000L);
    }

    public I18nMessage getI18nMessage(String code, Locale locale) {
        I18nData i18nData;
        String languageTag = locale.toLanguageTag();
        String cacheKey = this.getCacheKey(code, languageTag);
        I18nMessage i18nMessage = (I18nMessage)this.cache.get((Object)cacheKey);
        if (i18nMessage == null && (i18nData = this.i18nDataService.getByCodeAndLanguageTag(code, languageTag)) != null) {
            i18nMessage = this.converterToI18nMessage(i18nData);
            int timeout = RandomUtil.randomInt((int)3240000, (int)3960000);
            this.cache.put((Object)cacheKey, (Object)i18nMessage, (long)timeout);
        }
        return i18nMessage;
    }

    private String getCacheKey(String code, String languageTag) {
        return code + ":" + languageTag;
    }

    private I18nMessage converterToI18nMessage(I18nData i18nData) {
        I18nMessage i18nMessage = new I18nMessage();
        i18nMessage.setMessage(i18nData.getMessage());
        i18nMessage.setCode(i18nData.getCode());
        i18nMessage.setLanguageTag(i18nData.getLanguageTag());
        return i18nMessage;
    }

    protected void handleMessage(I18nDataUnique i18nDataUnique) {
        String cacheKey = this.getCacheKey(i18nDataUnique.getCode(), i18nDataUnique.getLanguageTag());
        this.cache.remove((Object)cacheKey);
    }

    public Topic topic() {
        return new ChannelTopic("channel:i18n-data-updated");
    }
}

