/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.i18n.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.redis.core.annotation.CacheDel;
import com.hccake.ballcat.common.redis.core.annotation.Cached;
import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.i18n.converter.I18nDataConverter;
import com.hccake.ballcat.i18n.mapper.I18nDataMapper;
import com.hccake.ballcat.i18n.model.dto.I18nDataDTO;
import com.hccake.ballcat.i18n.model.dto.I18nDataUnique;
import com.hccake.ballcat.i18n.model.entity.I18nData;
import com.hccake.ballcat.i18n.model.qo.I18nDataQO;
import com.hccake.ballcat.i18n.model.vo.I18nDataPageVO;
import com.hccake.ballcat.i18n.service.I18nDataService;
import com.hccake.extend.mybatis.plus.service.impl.ExtendServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class I18nDataServiceImpl
extends ExtendServiceImpl<I18nDataMapper, I18nData>
implements I18nDataService {
    private final StringRedisTemplate stringRedisTemplate;
    private final I18nDataTxSupport i18NDataTxSupport;

    @Override
    public PageResult<I18nDataPageVO> queryPage(PageParam pageParam, I18nDataQO qo) {
        return ((I18nDataMapper)this.baseMapper).queryPage(pageParam, qo);
    }

    @Override
    public List<I18nData> queryList(I18nDataQO i18nDataQO) {
        return ((I18nDataMapper)this.baseMapper).queryList(i18nDataQO);
    }

    @Override
    public List<I18nData> listByCode(String code) {
        return ((I18nDataMapper)this.baseMapper).listByCode(code);
    }

    @Override
    @Cached(key="i18n-data", keyJoint="#code + ':' + #languageTag")
    public I18nData getByCodeAndLanguageTag(String code, String languageTag) {
        return ((I18nDataMapper)this.baseMapper).selectByCodeAndLanguageTag(code, languageTag);
    }

    @CacheDel(key="i18n-data", keyJoint="#p0.code + ':' + #p0.languageTag")
    public boolean save(I18nData entity) {
        return SqlHelper.retBool((Integer)((I18nDataMapper)this.getBaseMapper()).insert(entity));
    }

    @Override
    @CacheDel(key="i18n-data", keyJoint="#p0.code + ':' + #p0.languageTag")
    public boolean updateByCodeAndLanguageTag(I18nDataDTO i18nDataDTO) {
        boolean updateSuccess = ((I18nDataMapper)this.baseMapper).updateByCodeAndLanguageTag(i18nDataDTO);
        if (updateSuccess) {
            this.pushUpdateMessage(i18nDataDTO.getCode(), i18nDataDTO.getLanguageTag());
        }
        return updateSuccess;
    }

    @Override
    @CacheDel(key="i18n-data", keyJoint="#code + ':' + #languageTag")
    public boolean removeByCodeAndLanguageTag(String code, String languageTag) {
        boolean deleteSuccess = ((I18nDataMapper)this.baseMapper).deleteByCodeAndLanguageTag(code, languageTag);
        if (deleteSuccess) {
            this.pushUpdateMessage(code, languageTag);
        }
        return deleteSuccess;
    }

    @Override
    @CacheDel(key="i18n-data", multiDel=true, keyJoint="#p0.![#this.code + ':' + #this.languageTag]")
    public List<I18nData> saveWhenNotExist(List<I18nData> list) {
        List<I18nData> existsI18nData = ((I18nDataMapper)this.baseMapper).exists(list);
        list.removeAll(existsI18nData);
        if (CollUtil.isNotEmpty(list)) {
            ((I18nDataMapper)this.baseMapper).insertBatchSomeColumn(list);
        }
        return existsI18nData;
    }

    @Override
    @CacheDel(key="i18n-data", multiDel=true, keyJoint="#p0.![#this.code + ':' + #this.languageTag]")
    public void saveOrUpdate(List<I18nData> list) {
        List<I18nData> existsI18nData = ((I18nDataMapper)this.baseMapper).exists(list);
        HashSet<I18nData> existsSet = new HashSet<I18nData>(existsI18nData);
        ArrayList<I18nDataDTO> updateList = new ArrayList<I18nDataDTO>();
        ArrayList<I18nData> insertList = new ArrayList<I18nData>();
        for (I18nData i18nData : list) {
            if (existsSet.contains(i18nData)) {
                updateList.add(I18nDataConverter.INSTANCE.poToDto(i18nData));
                continue;
            }
            insertList.add(i18nData);
        }
        this.i18NDataTxSupport.saveAndUpdate(insertList, updateList);
        for (I18nDataDTO i18nDataDTO : updateList) {
            String code = i18nDataDTO.getCode();
            String languageTag = i18nDataDTO.getLanguageTag();
            this.pushUpdateMessage(code, languageTag);
        }
    }

    @CacheDel(key="i18n-data", multiDel=true, keyJoint="#p0.![#this.code + ':' + #this.languageTag]")
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<I18nData> list) {
        return super.saveBatch(list);
    }

    private void pushUpdateMessage(String code, String languageTag) {
        I18nDataUnique channelBody = new I18nDataUnique(code, languageTag);
        String str = JsonUtils.toJson((Object)channelBody);
        this.stringRedisTemplate.convertAndSend("channel:i18n-data-updated", (Object)str);
    }

    public I18nDataServiceImpl(StringRedisTemplate stringRedisTemplate, I18nDataTxSupport i18NDataTxSupport) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.i18NDataTxSupport = i18NDataTxSupport;
    }

    @Component
    static class I18nDataTxSupport {
        private final I18nDataMapper i18nDataMapper;

        @Transactional(rollbackFor={Exception.class})
        public void saveAndUpdate(List<I18nData> insertList, List<I18nDataDTO> updateList) {
            if (CollUtil.isNotEmpty(insertList)) {
                this.i18nDataMapper.insertBatchSomeColumn(insertList);
            }
            for (I18nDataDTO i18nDataDTO : updateList) {
                this.i18nDataMapper.updateByCodeAndLanguageTag(i18nDataDTO);
            }
        }

        public I18nDataTxSupport(I18nDataMapper i18nDataMapper) {
            this.i18nDataMapper = i18nDataMapper;
        }
    }
}

