/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.log.handler;

import cn.hutool.core.util.URLUtil;
import com.hccake.ballcat.common.core.util.WebUtils;
import com.hccake.ballcat.common.log.operation.annotation.OperationLogging;
import com.hccake.ballcat.common.log.operation.enums.LogStatusEnum;
import com.hccake.ballcat.common.log.operation.handler.AbstractOperationLogHandler;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.common.util.IpUtils;
import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.log.model.entity.OperationLog;
import com.hccake.ballcat.log.service.OperationLogService;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.MDC;

public class CustomOperationLogHandler
extends AbstractOperationLogHandler<OperationLog> {
    private final OperationLogService operationLogService;

    public OperationLog buildLog(OperationLogging operationLogging, ProceedingJoinPoint joinPoint) {
        HttpServletRequest request = WebUtils.getRequest();
        OperationLog operationLog = new OperationLog().setCreateTime(LocalDateTime.now()).setIp(IpUtils.getIpAddr((HttpServletRequest)request)).setMethod(request.getMethod()).setUserAgent(request.getHeader("User-Agent")).setUri(URLUtil.getPath((String)request.getRequestURI())).setType(Integer.valueOf(operationLogging.type())).setMsg(operationLogging.msg()).setTraceId(MDC.get((String)"traceId"));
        if (operationLogging.recordParams()) {
            operationLog.setParams(this.getParams(joinPoint));
        }
        Optional.ofNullable(SecurityUtils.getUser()).ifPresent(x -> operationLog.setOperator(x.getUsername()));
        return operationLog;
    }

    public OperationLog recordExecutionInfo(OperationLog operationLog, ProceedingJoinPoint joinPoint, long executionTime, Throwable throwable, boolean isSaveResult, Object result) {
        operationLog.setTime(Long.valueOf(executionTime));
        LogStatusEnum logStatusEnum = throwable == null ? LogStatusEnum.SUCCESS : LogStatusEnum.FAIL;
        operationLog.setStatus(Integer.valueOf(logStatusEnum.getValue()));
        if (isSaveResult) {
            Optional.ofNullable(result).ifPresent(x -> operationLog.setResult(JsonUtils.toJson((Object)x)));
        }
        return operationLog;
    }

    public void handleLog(OperationLog operationLog) {
        this.operationLogService.saveAsync(operationLog);
    }

    public CustomOperationLogHandler(OperationLogService operationLogService) {
        this.operationLogService = operationLogService;
    }
}

