/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.handler;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.common.util.JsonUtils;
import com.hccake.ballcat.common.websocket.distribute.MessageDO;
import com.hccake.ballcat.common.websocket.distribute.MessageDistributor;
import com.hccake.ballcat.common.websocket.message.JsonWebSocketMessage;
import com.hccake.ballcat.notify.handler.NotifyInfoHandler;
import com.hccake.ballcat.notify.model.domain.NotifyInfo;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNotifyInfoHandler<T extends NotifyInfo, M extends JsonWebSocketMessage>
implements NotifyInfoHandler<T> {
    @Autowired
    private MessageDistributor messageDistributor;
    protected final Class<T> clz;

    protected AbstractNotifyInfoHandler() {
        Type superClass = this.getClass().getGenericSuperclass();
        ParameterizedType type = (ParameterizedType)superClass;
        this.clz = (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public void handle(List<SysUser> userList, T notifyInfo) {
        M message = this.createMessage(notifyInfo);
        String msg = JsonUtils.toJson(message);
        List sessionKeys = userList.stream().map(SysUser::getUserId).collect(Collectors.toList());
        this.persistMessage(userList, notifyInfo);
        MessageDO messageDO = new MessageDO().setMessageText(msg).setSessionKeys(sessionKeys).setNeedBroadcast(Boolean.valueOf(CollUtil.isEmpty(sessionKeys)));
        this.messageDistributor.distribute(messageDO);
    }

    @Override
    public Class<T> getNotifyClass() {
        return this.clz;
    }

    protected abstract void persistMessage(List<SysUser> var1, T var2);

    protected abstract M createMessage(T var1);
}

