/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.handler;

import com.hccake.ballcat.notify.handler.NotifyInfoHandler;
import com.hccake.ballcat.notify.model.domain.NotifyInfo;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class NotifyInfoDelegateHandler<T extends NotifyInfo> {
    private static final Logger log = LoggerFactory.getLogger(NotifyInfoDelegateHandler.class);
    private final List<NotifyInfoHandler<T>> notifyInfoHandlers;
    private Map<Class<?>, NotifyInfoHandler<T>> handlerMap;

    @PostConstruct
    public void init() {
        this.handlerMap = new HashMap(this.notifyInfoHandlers.size());
        for (NotifyInfoHandler<T> handler : this.notifyInfoHandlers) {
            this.handlerMap.put(handler.getNotifyClass(), handler);
        }
    }

    public void handle(List<SysUser> userList, T info) {
        Assert.notNull(info, (String)"event message cant be null!");
        NotifyInfoHandler<T> notifyInfoHandler = this.handlerMap.get(info.getClass());
        if (notifyInfoHandler == null) {
            log.warn("no notifyHandler bean for class:{},please check!", (Object)info.getClass().getName());
            return;
        }
        notifyInfoHandler.handle(userList, info);
    }

    public NotifyInfoDelegateHandler(List<NotifyInfoHandler<T>> notifyInfoHandlers, Map<Class<?>, NotifyInfoHandler<T>> handlerMap) {
        this.notifyInfoHandlers = notifyInfoHandlers;
        this.handlerMap = handlerMap;
    }
}

