/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.listener;

import com.hccake.ballcat.common.security.userdetails.User;
import com.hccake.ballcat.notify.enums.NotifyChannelEnum;
import com.hccake.ballcat.notify.model.entity.Announcement;
import com.hccake.ballcat.notify.recipient.RecipientHandler;
import com.hccake.ballcat.notify.service.AnnouncementService;
import com.hccake.ballcat.notify.service.UserAnnouncementService;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementLoginEventListener {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementLoginEventListener.class);
    private final AnnouncementService announcementService;
    private final RecipientHandler recipientHandler;
    private final UserAnnouncementService userAnnouncementService;

    @EventListener(value={AuthenticationSuccessEvent.class})
    public void onAuthenticationSuccessEvent(AuthenticationSuccessEvent event) throws InterruptedException {
        AbstractAuthenticationToken source = (AbstractAuthenticationToken)event.getSource();
        Object details = source.getDetails();
        if (!(details instanceof HashMap)) {
            return;
        }
        if ("password".equals(((HashMap)details).get("grant_type"))) {
            User user = (User)source.getPrincipal();
            SysUser sysUser = this.getSysUser(user);
            Long userId = sysUser.getUserId();
            List<Announcement> announcements = this.announcementService.listUnPulled(userId);
            Map<Integer, Object> filterAttrs = this.recipientHandler.getFilterAttrs(sysUser);
            List userAnnouncements = announcements.stream().filter(x -> x.getReceiveMode().contains(NotifyChannelEnum.STATION.getValue())).filter(x -> this.filterMatched((Announcement)x, filterAttrs)).map(Announcement::getId).map(id -> this.userAnnouncementService.prodUserAnnouncement(userId, (Long)id)).collect(Collectors.toList());
            try {
                this.userAnnouncementService.saveBatch(userAnnouncements);
            }
            catch (Exception exception) {
                log.error("\u7528\u6237\u516c\u544a\u4fdd\u5b58\u5931\u8d25\uff1a[{}]", userAnnouncements, (Object)exception);
            }
        }
    }

    private SysUser getSysUser(User user) {
        SysUser sysUser = new SysUser();
        sysUser.setUserId(user.getUserId());
        sysUser.setUsername(user.getUsername());
        sysUser.setNickname(user.getNickname());
        sysUser.setAvatar(user.getAvatar());
        sysUser.setOrganizationId(user.getOrganizationId());
        sysUser.setType(user.getType());
        return sysUser;
    }

    private boolean filterMatched(Announcement announ, Map<Integer, Object> filterAttrs) {
        Integer type = announ.getRecipientFilterType();
        return this.recipientHandler.match(type, filterAttrs.get(type), announ.getRecipientFilterCondition());
    }

    public AnnouncementLoginEventListener(AnnouncementService announcementService, RecipientHandler recipientHandler, UserAnnouncementService userAnnouncementService) {
        this.announcementService = announcementService;
        this.recipientHandler = recipientHandler;
        this.userAnnouncementService = userAnnouncementService;
    }
}

