/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.push;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.common.mail.model.MailDetails;
import com.hccake.ballcat.common.mail.sender.MailSender;
import com.hccake.ballcat.notify.enums.NotifyChannelEnum;
import com.hccake.ballcat.notify.model.domain.NotifyInfo;
import com.hccake.ballcat.notify.push.NotifyPusher;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.List;

public class MailNotifyPusher
implements NotifyPusher {
    private final MailSender mailSender;

    @Override
    public Integer notifyChannel() {
        return NotifyChannelEnum.MAIL.getValue();
    }

    @Override
    public void push(NotifyInfo notifyInfo, List<SysUser> userList) {
        String[] emails = (String[])userList.stream().map(SysUser::getEmail).filter(CharSequenceUtil::isNotBlank).toArray(String[]::new);
        MailDetails mailDetails = new MailDetails();
        mailDetails.setShowHtml(Boolean.valueOf(true));
        mailDetails.setSubject(notifyInfo.getTitle());
        mailDetails.setContent(notifyInfo.getContent());
        mailDetails.setBcc(emails);
        this.mailSender.sendMail(mailDetails);
    }

    public MailNotifyPusher(MailSender mailSender) {
        this.mailSender = mailSender;
    }
}

