/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.push;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.notify.model.domain.NotifyInfo;
import com.hccake.ballcat.notify.push.NotifyPusher;
import com.hccake.ballcat.notify.recipient.RecipientHandler;
import com.hccake.ballcat.system.model.entity.SysUser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotifyPushExecutor {
    private static final Logger log = LoggerFactory.getLogger(NotifyPushExecutor.class);
    private final RecipientHandler recipientHandler;
    private final Map<Integer, NotifyPusher> notifyPusherMap = new LinkedHashMap<Integer, NotifyPusher>();

    public NotifyPushExecutor(RecipientHandler recipientHandler, List<NotifyPusher> notifyPusherList) {
        this.recipientHandler = recipientHandler;
        if (CollUtil.isNotEmpty(notifyPusherList)) {
            for (NotifyPusher notifyPusher : notifyPusherList) {
                this.addNotifyPusher(notifyPusher);
            }
        }
    }

    public void addNotifyPusher(NotifyPusher notifyPusher) {
        this.notifyPusherMap.put(notifyPusher.notifyChannel(), notifyPusher);
    }

    public void push(NotifyInfo notifyInfo) {
        Integer recipientFilterType = notifyInfo.getRecipientFilterType();
        List recipientFilterCondition = notifyInfo.getRecipientFilterCondition();
        List<SysUser> userList = this.recipientHandler.query(recipientFilterType, recipientFilterCondition);
        for (Integer notifyChannel : notifyInfo.getReceiveMode()) {
            try {
                NotifyPusher notifyPusher = this.notifyPusherMap.get(notifyChannel);
                if (notifyPusher == null) {
                    log.error("Unknown notify channel\uff1a[{}]\uff0cnotifyInfo title\uff1a[{}]", (Object)notifyChannel, (Object)notifyInfo.getTitle());
                    continue;
                }
                notifyPusher.push(notifyInfo, userList);
            }
            catch (Exception e) {
                log.error("push notify error in channel\uff1a[{}]\uff0cnotifyInfo title\uff1a[{}]", new Object[]{notifyChannel, notifyInfo.getTitle(), e});
            }
        }
    }
}

