/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.recipient;

import cn.hutool.core.collection.CollUtil;
import com.hccake.ballcat.notify.enums.NotifyRecipientFilterTypeEnum;
import com.hccake.ballcat.notify.recipient.RecipientFilter;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.service.SysUserService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SpecifyRoleRecipientFilter
implements RecipientFilter {
    private final SysUserService sysUserService;

    @Override
    public Integer filterType() {
        return NotifyRecipientFilterTypeEnum.SPECIFY_ROLE.getValue();
    }

    @Override
    public List<SysUser> filter(List<Object> filterCondition) {
        List roleCodes = filterCondition.stream().map(String.class::cast).collect(Collectors.toList());
        return this.sysUserService.listByRoleCodes(roleCodes);
    }

    @Override
    public Object getFilterAttr(SysUser sysUser) {
        return this.sysUserService.listRoleCodes(sysUser.getUserId());
    }

    @Override
    public boolean match(Object filterAttr, List<Object> filterCondition) {
        if (!(filterAttr instanceof List)) {
            return false;
        }
        List roleCodes = (List)filterAttr;
        if (CollUtil.isEmpty((Collection)roleCodes)) {
            return false;
        }
        for (Object roleCode : roleCodes) {
            boolean matched = filterCondition.stream().map(String.class::cast).anyMatch(x -> x.equals(roleCode));
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public SpecifyRoleRecipientFilter(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }
}

