/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.recipient;

import com.hccake.ballcat.notify.enums.NotifyRecipientFilterTypeEnum;
import com.hccake.ballcat.notify.recipient.RecipientFilter;
import com.hccake.ballcat.system.model.entity.SysUser;
import com.hccake.ballcat.system.service.SysUserService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SpecifyUserRecipientFilter
implements RecipientFilter {
    private final SysUserService sysUserService;

    @Override
    public Integer filterType() {
        return NotifyRecipientFilterTypeEnum.SPECIFY_USER.getValue();
    }

    @Override
    public List<SysUser> filter(List<Object> filterCondition) {
        List userIds = filterCondition.stream().map(Long.class::cast).collect(Collectors.toList());
        return this.sysUserService.listByUserIds(userIds);
    }

    @Override
    public Object getFilterAttr(SysUser sysUser) {
        return sysUser.getUserId();
    }

    @Override
    public boolean match(Object filterAttr, List<Object> filterCondition) {
        Long userId = (Long)filterAttr;
        return filterCondition.stream().map(Long.class::cast).anyMatch(x -> x.equals(userId));
    }

    public SpecifyUserRecipientFilter(SysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }
}

