/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.controller;

import com.hccake.ballcat.common.log.operation.annotation.CreateOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.DeleteOperationLogging;
import com.hccake.ballcat.common.log.operation.annotation.UpdateOperationLogging;
import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.BaseResultCode;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.notify.model.dto.AnnouncementDTO;
import com.hccake.ballcat.notify.model.entity.Announcement;
import com.hccake.ballcat.notify.model.qo.AnnouncementQO;
import com.hccake.ballcat.notify.model.vo.AnnouncementPageVO;
import com.hccake.ballcat.notify.service.AnnouncementService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/notify/announcement"})
@Tag(name="\u516c\u544a\u4fe1\u606f\u7ba1\u7406")
public class AnnouncementController {
    private final AnnouncementService announcementService;

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('notify:announcement:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<PageResult<AnnouncementPageVO>> getAnnouncementPage(@Validated PageParam pageParam, AnnouncementQO announcementQO) {
        return R.ok((Object)this.announcementService.queryPage(pageParam, announcementQO));
    }

    @CreateOperationLogging(msg="\u65b0\u589e\u516c\u544a\u4fe1\u606f")
    @PostMapping
    @PreAuthorize(value="@per.hasPermission('notify:announcement:add')")
    @Operation(summary="\u65b0\u589e\u516c\u544a\u4fe1\u606f", description="\u65b0\u589e\u516c\u544a\u4fe1\u606f")
    public R<Void> save(@Valid @RequestBody AnnouncementDTO announcementDTO) {
        return this.announcementService.addAnnouncement(announcementDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u65b0\u589e\u516c\u544a\u4fe1\u606f\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u4fee\u6539\u516c\u544a\u4fe1\u606f")
    @PutMapping
    @PreAuthorize(value="@per.hasPermission('notify:announcement:edit')")
    @Operation(summary="\u4fee\u6539\u516c\u544a\u4fe1\u606f", description="\u4fee\u6539\u516c\u544a\u4fe1\u606f")
    public R<Void> updateById(@Valid @RequestBody AnnouncementDTO announcementDTO) {
        return this.announcementService.updateAnnouncement(announcementDTO) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u4fee\u6539\u516c\u544a\u4fe1\u606f\u5931\u8d25");
    }

    @DeleteOperationLogging(msg="\u901a\u8fc7id\u5220\u9664\u516c\u544a\u4fe1\u606f")
    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="@per.hasPermission('notify:announcement:del')")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664\u516c\u544a\u4fe1\u606f", description="\u901a\u8fc7id\u5220\u9664\u516c\u544a\u4fe1\u606f")
    public R<Void> removeById(@PathVariable(value="id") Long id) {
        return this.announcementService.removeById((Serializable)id) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u901a\u8fc7id\u5220\u9664\u516c\u544a\u4fe1\u606f\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u53d1\u5e03\u516c\u544a\u4fe1\u606f")
    @PatchMapping(value={"/publish/{announcementId}"})
    @PreAuthorize(value="@per.hasPermission('notify:announcement:edit')")
    @Operation(summary="\u53d1\u5e03\u516c\u544a\u4fe1\u606f", description="\u53d1\u5e03\u516c\u544a\u4fe1\u606f")
    public R<Void> enableAnnouncement(@PathVariable(value="announcementId") Long announcementId) {
        return this.announcementService.publish(announcementId) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u53d1\u5e03\u516c\u544a\u4fe1\u606f\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u5173\u95ed\u516c\u544a\u4fe1\u606f")
    @PatchMapping(value={"/close/{announcementId}"})
    @PreAuthorize(value="@per.hasPermission('notify:announcement:edit')")
    @Operation(summary="\u5173\u95ed\u516c\u544a\u4fe1\u606f", description="\u5173\u95ed\u516c\u544a\u4fe1\u606f")
    public R<Void> disableAnnouncement(@PathVariable(value="announcementId") Long announcementId) {
        return this.announcementService.close(announcementId) ? R.ok() : R.failed((ResultCode)BaseResultCode.UPDATE_DATABASE_ERROR, (String)"\u5173\u95ed\u516c\u544a\u4fe1\u606f\u5931\u8d25");
    }

    @UpdateOperationLogging(msg="\u516c\u544a\u5185\u5bb9\u56fe\u7247\u4e0a\u4f20", recordParams=false)
    @PreAuthorize(value="@per.hasPermission('notify:announcement:edit')")
    @PostMapping(value={"/image"})
    @Operation(summary="\u516c\u544a\u5185\u5bb9\u56fe\u7247\u4e0a\u4f20", description="\u516c\u544a\u5185\u5bb9\u56fe\u7247\u4e0a\u4f20")
    public R<List<String>> uploadImages(@RequestParam(value="files") List<MultipartFile> files) {
        List objectNames = this.announcementService.uploadImages(files);
        return R.ok((Object)objectNames);
    }

    @GetMapping(value={"/user"})
    @PreAuthorize(value="@per.hasPermission('notify:userannouncement:read')")
    @Operation(summary="\u7528\u6237\u516c\u544a\u4fe1\u606f", description="\u7528\u6237\u516c\u544a\u4fe1\u606f")
    public R<List<Announcement>> getUserAnnouncements() {
        Long userId = SecurityUtils.getUser().getUserId();
        return R.ok((Object)this.announcementService.listActiveAnnouncements(userId));
    }

    public AnnouncementController(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }
}

