/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.notify.controller;

import com.hccake.ballcat.common.model.domain.PageParam;
import com.hccake.ballcat.common.model.domain.PageResult;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.notify.model.qo.UserAnnouncementQO;
import com.hccake.ballcat.notify.model.vo.UserAnnouncementPageVO;
import com.hccake.ballcat.notify.service.UserAnnouncementService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify/user-announcement"})
@Tag(name="\u7528\u6237\u516c\u544a\u8868\u7ba1\u7406")
public class UserAnnouncementController {
    private final UserAnnouncementService userAnnouncementService;

    @GetMapping(value={"/page"})
    @PreAuthorize(value="@per.hasPermission('notify:userannouncement:read')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2", description="\u5206\u9875\u67e5\u8be2")
    public R<PageResult<UserAnnouncementPageVO>> getUserAnnouncementPage(@Validated PageParam pageParam, UserAnnouncementQO userAnnouncementQO) {
        return R.ok((Object)this.userAnnouncementService.queryPage(pageParam, userAnnouncementQO));
    }

    @PatchMapping(value={"/read/{announcementId}"})
    @PreAuthorize(value="@per.hasPermission('notify:userannouncement:read')")
    @Operation(summary="\u7528\u6237\u516c\u544a\u5df2\u8bfb\u4e0a\u62a5", description="\u7528\u6237\u516c\u544a\u5df2\u8bfb\u4e0a\u62a5")
    public R<Void> readAnnouncement(@PathVariable(value="announcementId") Long announcementId) {
        Long userId = SecurityUtils.getUser().getUserId();
        this.userAnnouncementService.readAnnouncement(userId, announcementId);
        return R.ok();
    }

    public UserAnnouncementController(UserAnnouncementService userAnnouncementService) {
        this.userAnnouncementService = userAnnouncementService;
    }
}

