/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.mail.sender;

import com.hccake.ballcat.common.mail.model.MailDetails;
import com.hccake.ballcat.common.mail.model.MailSendInfo;
import java.util.List;
import org.springframework.mail.MailSendException;
import org.springframework.util.StringUtils;

public interface MailSender {
    public MailSendInfo sendMail(MailDetails var1);

    default public MailSendInfo sendMail(String subject, String content, boolean showHtml, String ... to) {
        MailDetails mailDetails = new MailDetails();
        mailDetails.setShowHtml(showHtml);
        mailDetails.setSubject(subject);
        mailDetails.setContent(content);
        mailDetails.setTo(to);
        return this.sendMail(mailDetails);
    }

    default public MailSendInfo sendTextMail(String subject, String content, String ... to) {
        return this.sendMail(subject, content, false, to);
    }

    default public MailSendInfo sendTextMail(String subject, String content, List<String> to) {
        return this.sendMail(subject, content, false, to.toArray(new String[0]));
    }

    default public MailSendInfo sendHtmlMail(String subject, String content, String ... to) {
        return this.sendMail(subject, content, true, to);
    }

    default public MailSendInfo sendHtmlMail(String subject, String content, List<String> to) {
        return this.sendHtmlMail(subject, content, to.toArray(new String[0]));
    }

    default public void checkMail(MailDetails mailDetails) {
        boolean noBcc;
        boolean noTo = mailDetails.getTo() == null || mailDetails.getTo().length <= 0;
        boolean noCc = mailDetails.getCc() == null || mailDetails.getCc().length <= 0;
        boolean bl = noBcc = mailDetails.getBcc() == null || mailDetails.getBcc().length <= 0;
        if (noTo && noCc && noBcc) {
            throw new MailSendException("The email should have at least one recipient");
        }
        if (!StringUtils.hasText((String)mailDetails.getSubject())) {
            throw new MailSendException("The subject of the email cannot be empty");
        }
        if (!StringUtils.hasText((String)mailDetails.getContent())) {
            throw new MailSendException("The content of the email cannot be empty");
        }
    }
}

