/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.mail.sender;

import com.hccake.ballcat.common.mail.event.MailSendEvent;
import com.hccake.ballcat.common.mail.model.MailDetails;
import com.hccake.ballcat.common.mail.model.MailSendInfo;
import com.hccake.ballcat.common.mail.sender.MailSender;
import java.io.File;
import java.time.LocalDateTime;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;

public class MailSenderImpl
implements MailSender {
    private static final Logger log = LoggerFactory.getLogger(MailSenderImpl.class);
    private final JavaMailSender mailSender;
    private final ApplicationEventPublisher eventPublisher;
    @Value(value="${spring.mail.properties.from}")
    private String defaultFrom;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailSendInfo sendMail(MailDetails mailDetails) {
        MailSendInfo mailSendInfo = new MailSendInfo(mailDetails);
        mailSendInfo.setSentDate(LocalDateTime.now());
        try {
            this.checkMail(mailDetails);
            this.sendMimeMail(mailDetails);
            mailSendInfo.setSuccess(true);
        }
        catch (Exception e) {
            mailSendInfo.setSuccess(false);
            mailSendInfo.setErrorMsg(e.getMessage());
            log.error("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25: [{}]", (Object)mailDetails, (Object)e);
        }
        finally {
            this.eventPublisher.publishEvent((ApplicationEvent)new MailSendEvent(mailSendInfo));
        }
        return mailSendInfo;
    }

    private void sendMimeMail(MailDetails mailDetails) throws MessagingException {
        MimeMessageHelper messageHelper = new MimeMessageHelper(this.mailSender.createMimeMessage(), true);
        String from = StringUtils.hasText((String)mailDetails.getFrom()) ? mailDetails.getFrom() : this.defaultFrom;
        messageHelper.setFrom(from);
        messageHelper.setSubject(mailDetails.getSubject());
        if (mailDetails.getTo() != null && mailDetails.getTo().length > 0) {
            messageHelper.setTo(mailDetails.getTo());
        }
        if (mailDetails.getCc() != null && mailDetails.getCc().length > 0) {
            messageHelper.setCc(mailDetails.getCc());
        }
        if (mailDetails.getBcc() != null && mailDetails.getBcc().length > 0) {
            messageHelper.setBcc(mailDetails.getBcc());
        }
        boolean showHtml = mailDetails.getShowHtml() != null && mailDetails.getShowHtml() != false;
        messageHelper.setText(mailDetails.getContent(), showHtml);
        if (mailDetails.getFiles() != null) {
            for (File file : mailDetails.getFiles()) {
                messageHelper.addAttachment(file.getName(), file);
            }
        }
        this.mailSender.send(messageHelper.getMimeMessage());
        log.info("\u53d1\u9001\u90ae\u4ef6\u6210\u529f\uff1a[{}]", (Object)mailDetails);
    }

    public MailSenderImpl(JavaMailSender mailSender, ApplicationEventPublisher eventPublisher) {
        this.mailSender = mailSender;
        this.eventPublisher = eventPublisher;
    }
}

