/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hccake.ballcat.common.redis.RedisHelper;
import com.hccake.ballcat.common.redis.config.CacheProperties;
import com.hccake.ballcat.common.redis.config.CachePropertiesHolder;
import com.hccake.ballcat.common.redis.core.CacheStringAspect;
import com.hccake.ballcat.common.redis.prefix.IRedisPrefixConverter;
import com.hccake.ballcat.common.redis.prefix.impl.DefaultRedisPrefixConverter;
import com.hccake.ballcat.common.redis.serialize.CacheSerializer;
import com.hccake.ballcat.common.redis.serialize.JacksonSerializer;
import com.hccake.ballcat.common.redis.serialize.PrefixJdkRedisSerializer;
import com.hccake.ballcat.common.redis.serialize.PrefixStringRedisSerializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

@AutoConfiguration(before={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheProperties.class})
public class BallcatRedisAutoConfiguration {
    private final RedisConnectionFactory redisConnectionFactory;

    @Bean
    @ConditionalOnMissingBean
    public CachePropertiesHolder cachePropertiesHolder(CacheProperties cacheProperties) {
        CachePropertiesHolder cachePropertiesHolder = new CachePropertiesHolder();
        cachePropertiesHolder.setCacheProperties(cacheProperties);
        return cachePropertiesHolder;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheSerializer cacheSerializer(ObjectMapper objectMapper) {
        return new JacksonSerializer(objectMapper);
    }

    @Bean
    @DependsOn(value={"cachePropertiesHolder"})
    @ConditionalOnProperty(prefix="ballcat.redis", name={"key-prefix"})
    @ConditionalOnMissingBean(value={IRedisPrefixConverter.class})
    public IRedisPrefixConverter redisPrefixConverter() {
        return new DefaultRedisPrefixConverter(CachePropertiesHolder.keyPrefix());
    }

    @Bean
    @ConditionalOnBean(value={IRedisPrefixConverter.class})
    @ConditionalOnMissingBean
    public StringRedisTemplate stringRedisTemplate(IRedisPrefixConverter redisPrefixConverter) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new PrefixStringRedisSerializer(redisPrefixConverter));
        return template;
    }

    @Bean
    @ConditionalOnBean(value={IRedisPrefixConverter.class})
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(IRedisPrefixConverter redisPrefixConverter) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.redisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new PrefixJdkRedisSerializer(redisPrefixConverter));
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisHelper.class})
    public RedisHelper redisHelper(StringRedisTemplate template) {
        RedisHelper.setRedisTemplate((RedisTemplate)template);
        return RedisHelper.INSTANCE;
    }

    @Bean
    @DependsOn(value={"redisHelper"})
    @ConditionalOnMissingBean
    public CacheStringAspect cacheStringAspect(StringRedisTemplate stringRedisTemplate, CacheSerializer cacheSerializer) {
        return new CacheStringAspect(stringRedisTemplate, cacheSerializer);
    }

    public BallcatRedisAutoConfiguration(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }
}

