/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.redis;

import com.hccake.ballcat.common.redis.keyevent.listener.AbstractDeletedKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.listener.AbstractExpiredKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.listener.AbstractSetKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.listener.DefaultDeletedKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.listener.DefaultExpiredKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.listener.DefaultSetKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.template.KeyDeletedEventMessageTemplate;
import com.hccake.ballcat.common.redis.keyevent.template.KeyExpiredEventMessageTemplate;
import com.hccake.ballcat.common.redis.keyevent.template.KeySetEventMessageTemplate;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@AutoConfiguration
public class RedisKeyEventAutoConfiguration {
    public static final String KEY_DELETED_EVENT_PREFIX = "ballcat.redis.key-deleted-event";
    public static final String KEY_SET_EVENT_PREFIX = "ballcat.redis.key-set-event";
    public static final String KEY_EXPIRED_EVENT_PREFIX = "ballcat.redis.key-expired-event";

    @ConditionalOnProperty(prefix="ballcat.redis.key-expired-event", name={"enabled"}, havingValue="true")
    public static class RedisKeyExpiredEventConfiguration {
        public static final String CONTAINER_NAME = "keyExpiredEventRedisMessageListenerContainer";
        public static final String LISTENER_NAME = "keyExpiredEventMessageListener";

        @Bean(name={"keyExpiredEventRedisMessageListenerContainer"})
        @ConditionalOnMissingBean(name={"keyExpiredEventRedisMessageListenerContainer"})
        public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            return container;
        }

        @Bean(name={"keyExpiredEventMessageListener"})
        @ConditionalOnMissingBean(name={"keyExpiredEventMessageListener"})
        public AbstractExpiredKeyEventMessageListener keyExpiredEventMessageListener(@Qualifier(value="keyExpiredEventRedisMessageListenerContainer") RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeyExpiredEventMessageTemplate>> objectProvider) {
            return new DefaultExpiredKeyEventMessageListener(listenerContainer, objectProvider);
        }
    }

    @ConditionalOnProperty(prefix="ballcat.redis.key-set-event", name={"enabled"}, havingValue="true")
    public static class RedisKeySetEventConfiguration {
        public static final String CONTAINER_NAME = "keySetEventRedisMessageListenerContainer";
        public static final String LISTENER_NAME = "keySetEventMessageListener";

        @Bean(name={"keySetEventRedisMessageListenerContainer"})
        @ConditionalOnMissingBean(name={"keySetEventRedisMessageListenerContainer"})
        public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            return container;
        }

        @Bean(name={"keySetEventMessageListener"})
        @ConditionalOnMissingBean(name={"keySetEventMessageListener"})
        public AbstractSetKeyEventMessageListener keySetEventMessageListener(@Qualifier(value="keySetEventRedisMessageListenerContainer") RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeySetEventMessageTemplate>> objectProvider) {
            return new DefaultSetKeyEventMessageListener(listenerContainer, objectProvider);
        }
    }

    @ConditionalOnProperty(prefix="ballcat.redis.key-deleted-event", name={"enabled"}, havingValue="true")
    public static class RedisKeyDeletedEventConfiguration {
        public static final String CONTAINER_NAME = "keyDeleteEventRedisMessageListenerContainer";
        public static final String LISTENER_NAME = "keyDeletedEventMessageListener";

        @Bean(name={"keyDeleteEventRedisMessageListenerContainer"})
        @ConditionalOnMissingBean(name={"keyDeleteEventRedisMessageListenerContainer"})
        public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            return container;
        }

        @Bean(name={"keyDeletedEventMessageListener"})
        @ConditionalOnMissingBean(name={"keyDeletedEventMessageListener"})
        public AbstractDeletedKeyEventMessageListener keyDeletedEventMessageListener(@Qualifier(value="keyDeleteEventRedisMessageListenerContainer") RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeyDeletedEventMessageTemplate>> objectProvider) {
            return new DefaultDeletedKeyEventMessageListener(listenerContainer, objectProvider);
        }
    }
}

