/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.actuate;

import cn.hutool.core.text.CharSequenceUtil;
import com.hccake.ballcat.autoconfigure.web.actuate.ActuatorSecurityFilter;
import com.hccake.ballcat.autoconfigure.web.actuate.ActuatorSecurityProperties;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(value={WebEndpointProperties.class})
@ConditionalOnProperty(prefix="ballcat.actuator", name={"auth"}, havingValue="true")
@EnableConfigurationProperties(value={ActuatorSecurityProperties.class})
public class ActuatorSecurityAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ActuatorSecurityAutoConfiguration.class);
    private final WebEndpointProperties webEndpointProperties;

    @Bean
    public FilterRegistrationBean<ActuatorSecurityFilter> actuatorFilterRegistrationBean(ActuatorSecurityProperties actuatorSecurityProperties) {
        log.debug("Actuator \u8fc7\u6ee4\u5668\u5df2\u5f00\u542f====");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        if (actuatorSecurityProperties.isAuth()) {
            ActuatorSecurityFilter filter = new ActuatorSecurityFilter(actuatorSecurityProperties.getSecretId(), actuatorSecurityProperties.getSecretKey());
            registrationBean.setFilter((Filter)filter);
            String basePath = this.webEndpointProperties.getBasePath();
            if (CharSequenceUtil.isBlank((CharSequence)basePath)) {
                basePath = "/actuator";
            }
            registrationBean.addUrlPatterns(new String[]{basePath + "/*"});
            registrationBean.setOrder(0);
        }
        return registrationBean;
    }

    public ActuatorSecurityAutoConfiguration(WebEndpointProperties webEndpointProperties) {
        this.webEndpointProperties = webEndpointProperties;
    }
}

