/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.exception.handler;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.exceptions.ExceptionUtil;
import com.hccake.ballcat.autoconfigure.web.exception.ExceptionHandleProperties;
import com.hccake.ballcat.autoconfigure.web.exception.domain.ExceptionMessage;
import com.hccake.ballcat.autoconfigure.web.exception.domain.ExceptionNoticeResponse;
import com.hccake.ballcat.common.core.exception.handler.GlobalExceptionHandler;
import com.hccake.ballcat.common.core.util.WebUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractNoticeGlobalExceptionHandler
extends Thread
implements GlobalExceptionHandler,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractNoticeGlobalExceptionHandler.class);
    private final BlockingQueue<Throwable> queue = new LinkedBlockingQueue<Throwable>();
    private static final String NULL_MESSAGE_KEY = "";
    protected final ExceptionHandleProperties config;
    private final Map<String, ExceptionMessage> messages;
    private String mac;
    private String hostname;
    private String ip;
    private String requestUri;
    private final String applicationName;

    protected AbstractNoticeGlobalExceptionHandler(ExceptionHandleProperties config, String applicationName) {
        this.config = config;
        this.messages = new ConcurrentHashMap<String, ExceptionMessage>(config.getMax() * 2);
        this.applicationName = applicationName;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            this.hostname = ia.getHostName();
            this.ip = ia.getHostAddress();
            byte[] macByte = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < macByte.length; ++i) {
                sb.append(String.format("%02X%s", macByte[i], i < macByte.length - 1 ? "-" : NULL_MESSAGE_KEY));
            }
            this.mac = sb.toString();
        }
        catch (Exception e) {
            this.mac = "\u83b7\u53d6\u5931\u8d25!";
        }
    }

    @Override
    public void run() {
        TimeInterval interval = new TimeInterval();
        long threadId = Thread.currentThread().getId();
        while (!this.isInterrupted()) {
            int i = 0;
            while (i < this.config.getMax() && interval.intervalSecond() < this.config.getTime()) {
                String key;
                Throwable t = null;
                try {
                    t = this.queue.poll(i == 0 ? TimeUnit.HOURS.toSeconds(1L) : 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
                if (t == null) continue;
                String string = key = t.getMessage() == null ? NULL_MESSAGE_KEY : t.getMessage();
                if (i++ == 0) {
                    interval.restart();
                    this.messages.put(key, this.toMessage(t).setKey(key).setThreadId(threadId));
                    continue;
                }
                if (this.messages.containsKey(key)) {
                    this.messages.put(key, this.messages.get(key).increment());
                    continue;
                }
                this.messages.put(key, this.toMessage(t).setKey(key).setThreadId(threadId));
            }
            if (this.messages.size() > 0) {
                this.messages.forEach((k, v) -> {
                    try {
                        ExceptionNoticeResponse response = this.send((ExceptionMessage)v);
                        if (!response.isSuccess()) {
                            log.error("\u6d88\u606f\u901a\u77e5\u53d1\u9001\u5931\u8d25! msg: {}", (Object)response.getErrMsg());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u6d88\u606f\u901a\u77e5\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                    }
                });
                this.messages.clear();
            }
            interval.restart();
        }
    }

    public ExceptionMessage toMessage(Throwable t) {
        return new ExceptionMessage().setNumber(1).setMac(this.mac).setApplicationName(this.applicationName).setHostname(this.hostname).setIp(this.ip).setRequestUri(this.requestUri).setStack(ExceptionUtil.stacktraceToString((Throwable)t, (int)this.config.getLength()).replace("\\r", NULL_MESSAGE_KEY)).setTime(DateUtil.now());
    }

    public abstract ExceptionNoticeResponse send(ExceptionMessage var1);

    public void handle(Throwable throwable) {
        try {
            this.requestUri = WebUtils.getRequest().getRequestURI();
            boolean ignore = false;
            if (Boolean.FALSE.equals(this.config.getIgnoreChild())) {
                ignore = this.config.getIgnoreExceptions().contains(throwable.getClass());
            } else {
                for (Class<? extends Throwable> ignoreException : this.config.getIgnoreExceptions()) {
                    if (!ignoreException.isAssignableFrom(throwable.getClass())) continue;
                    ignore = true;
                    break;
                }
            }
            if (!ignore) {
                this.queue.put(throwable);
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
        catch (Exception e) {
            log.error("\u5f80\u5f02\u5e38\u6d88\u606f\u961f\u5217\u63d2\u5165\u65b0\u5f02\u5e38\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        this.setName("exception-notice");
        this.start();
    }
}

