/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.exception.resolver;

import com.hccake.ballcat.common.core.exception.BusinessException;
import com.hccake.ballcat.common.core.exception.handler.GlobalExceptionHandler;
import com.hccake.ballcat.common.model.result.R;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Order
@RestControllerAdvice
public class GlobalHandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(GlobalHandlerExceptionResolver.class);
    private final GlobalExceptionHandler globalExceptionHandler;
    @Value(value="${spring.profiles.active:prod}")
    private String profile;
    public static final String PROD_ERR_MSG = "\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
    public static final String NLP_MSG = "\u7a7a\u6307\u9488\u5f02\u5e38!";

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<String> handleGlobalException(Exception e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u5168\u5c40\u5f02\u5e38\u4fe1\u606f ex={}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        this.globalExceptionHandler.handle((Throwable)e);
        String errorMessage = "prod".equals(this.profile) ? PROD_ERR_MSG : e.getLocalizedMessage();
        return R.failed((ResultCode)SystemResultCode.SERVER_ERROR, (String)errorMessage);
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<String> handleNullPointerException(NullPointerException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u7a7a\u6307\u9488\u5f02\u5e38 ex={}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        this.globalExceptionHandler.handle((Throwable)e);
        String errorMessage = "prod".equals(this.profile) ? PROD_ERR_MSG : NLP_MSG;
        return R.failed((ResultCode)SystemResultCode.SERVER_ERROR, (String)errorMessage);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public R<String> handleMethodArgumentTypeMismatchException(Exception e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u8bf7\u6c42\u5165\u53c2\u5f02\u5e38 ex={}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        this.globalExceptionHandler.handle((Throwable)e);
        String errorMessage = "prod".equals(this.profile) ? PROD_ERR_MSG : e.getMessage();
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)errorMessage);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class, HttpRequestMethodNotSupportedException.class})
    public R<String> requestNotSupportedException(Exception e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u8bf7\u6c42\u65b9\u5f0f\u5f02\u5e38 ex={}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)e.getLocalizedMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<String> handleIllegalArgumentException(IllegalArgumentException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u975e\u6cd5\u6570\u636e\u8f93\u5165 ex={}", new Object[]{request.getRequestURI(), e.getMessage(), e});
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<String> handleBodyValidException(BindException e, HttpServletRequest request) {
        BindingResult bindingResult = e.getBindingResult();
        String errorMsg = bindingResult.getErrorCount() > 0 ? ((ObjectError)bindingResult.getAllErrors().get(0)).getDefaultMessage() : "\u672a\u83b7\u53d6\u5230\u9519\u8bef\u4fe1\u606f!";
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u53c2\u6570\u7ed1\u5b9a\u5f02\u5e38 ex={}", (Object)request.getRequestURI(), (Object)errorMsg);
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)errorMsg);
    }

    @ExceptionHandler(value={ValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R<String> handleValidationException(ValidationException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u53c2\u6570\u6821\u9a8c\u5f02\u5e38 ex={}", (Object)request.getRequestURI(), (Object)e.getMessage());
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((ResultCode)SystemResultCode.BAD_REQUEST, (String)e.getLocalizedMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public R<String> handleBallCatException(BusinessException e, HttpServletRequest request) {
        log.error("\u8bf7\u6c42\u5730\u5740: {}, \u4e1a\u52a1\u5f02\u5e38\u4fe1\u606f ex={}", (Object)request.getRequestURI(), (Object)e.getMessage());
        this.globalExceptionHandler.handle((Throwable)e);
        return R.failed((int)e.getCode(), (String)e.getMessage());
    }

    public GlobalHandlerExceptionResolver(GlobalExceptionHandler globalExceptionHandler) {
        this.globalExceptionHandler = globalExceptionHandler;
    }
}

