/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.web.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.hccake.ballcat.common.core.jackson.CustomJavaTimeModule;
import com.hccake.ballcat.common.core.jackson.NullSerializerProvider;
import com.hccake.ballcat.common.desensitize.json.DesensitizeStrategy;
import com.hccake.ballcat.common.desensitize.json.JsonDesensitizeModule;
import com.hccake.ballcat.common.desensitize.json.JsonDesensitizeSerializerModifier;
import com.hccake.ballcat.common.util.json.JacksonJsonToolAdapter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@AutoConfiguration(before={JacksonAutoConfiguration.class})
public class CustomJacksonAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={ObjectMapper.class})
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setSerializerProvider((DefaultSerializerProvider)new NullSerializerProvider());
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        JacksonJsonToolAdapter.setMapper((ObjectMapper)objectMapper);
        return objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomJavaTimeModule.class})
    public CustomJavaTimeModule customJavaTimeModule() {
        return new CustomJavaTimeModule();
    }

    @Bean
    @ConditionalOnMissingBean(value={JsonDesensitizeModule.class, DesensitizeStrategy.class})
    public JsonDesensitizeModule jsonDesensitizeModule() {
        JsonDesensitizeSerializerModifier desensitizeModifier = new JsonDesensitizeSerializerModifier();
        return new JsonDesensitizeModule(desensitizeModifier);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={DesensitizeStrategy.class})
    public JsonDesensitizeModule jsonDesensitizeModule(DesensitizeStrategy desensitizeStrategy) {
        JsonDesensitizeSerializerModifier desensitizeModifier = new JsonDesensitizeSerializerModifier(desensitizeStrategy);
        return new JsonDesensitizeModule(desensitizeModifier);
    }
}

