/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.websocket.config;

import com.hccake.ballcat.common.websocket.distribute.MessageDistributor;
import com.hccake.ballcat.common.websocket.distribute.RedisMessageDistributor;
import com.hccake.ballcat.common.websocket.distribute.RedisMessageListenerInitializer;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

@ConditionalOnClass(value={StringRedisTemplate.class})
@ConditionalOnProperty(prefix="ballcat.websocket", name={"message-distributor"}, havingValue="redis")
@Configuration(proxyBeanMethods=false)
public class RedisMessageDistributorConfig {
    private final WebSocketSessionStore webSocketSessionStore;

    @Bean
    @ConditionalOnMissingBean(value={MessageDistributor.class})
    public RedisMessageDistributor messageDistributor(StringRedisTemplate stringRedisTemplate) {
        return new RedisMessageDistributor(this.webSocketSessionStore, stringRedisTemplate);
    }

    @Bean
    @ConditionalOnBean(value={RedisMessageDistributor.class})
    @ConditionalOnMissingBean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisMessageListenerInitializer redisMessageListenerInitializer(RedisMessageListenerContainer redisMessageListenerContainer, RedisMessageDistributor redisWebsocketMessageListener) {
        return new RedisMessageListenerInitializer(redisMessageListenerContainer, redisWebsocketMessageListener);
    }

    public RedisMessageDistributorConfig(WebSocketSessionStore webSocketSessionStore) {
        this.webSocketSessionStore = webSocketSessionStore;
    }
}

