/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.websocket.config;

import com.hccake.ballcat.common.websocket.distribute.MessageDistributor;
import com.hccake.ballcat.common.websocket.distribute.RocketmqMessageDistributor;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="ballcat.websocket", name={"message-distributor"}, havingValue="rocketmq")
@Configuration(proxyBeanMethods=false)
public class RocketMqMessageDistributorConfig {
    private final WebSocketSessionStore webSocketSessionStore;

    @Bean
    @ConditionalOnMissingBean(value={MessageDistributor.class})
    public RocketmqMessageDistributor messageDistributor(RocketMQTemplate template) {
        return new RocketmqMessageDistributor(this.webSocketSessionStore, template);
    }

    public RocketMqMessageDistributorConfig(WebSocketSessionStore webSocketSessionStore) {
        this.webSocketSessionStore = webSocketSessionStore;
    }
}

