/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.autoconfigure.websocket.config;

import com.hccake.ballcat.autoconfigure.websocket.WebSocketProperties;
import com.hccake.ballcat.common.websocket.handler.CustomWebSocketHandler;
import com.hccake.ballcat.common.websocket.handler.PlanTextMessageHandler;
import com.hccake.ballcat.common.websocket.session.DefaultWebSocketSessionStore;
import com.hccake.ballcat.common.websocket.session.MapSessionWebSocketHandlerDecorator;
import com.hccake.ballcat.common.websocket.session.SessionKeyGenerator;
import com.hccake.ballcat.common.websocket.session.WebSocketSessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.socket.WebSocketHandler;

public class WebSocketHandlerConfig {
    private final WebSocketProperties webSocketProperties;

    @Bean
    @ConditionalOnMissingBean
    public WebSocketSessionStore webSocketSessionStore(@Autowired(required=false) SessionKeyGenerator sessionKeyGenerator) {
        return new DefaultWebSocketSessionStore(sessionKeyGenerator);
    }

    @Bean
    @ConditionalOnMissingBean(value={WebSocketHandler.class})
    public WebSocketHandler webSocketHandler(WebSocketSessionStore webSocketSessionStore, @Autowired(required=false) PlanTextMessageHandler planTextMessageHandler) {
        CustomWebSocketHandler customWebSocketHandler = new CustomWebSocketHandler(planTextMessageHandler);
        if (this.webSocketProperties.isMapSession()) {
            return new MapSessionWebSocketHandlerDecorator((WebSocketHandler)customWebSocketHandler, webSocketSessionStore, this.webSocketProperties.getConcurrent());
        }
        return customWebSocketHandler;
    }

    public WebSocketHandlerConfig(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }
}

